/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.conditiondata;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionData;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionID;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionScope;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ConditionDataContainer
implements INBTSerializer {
    private Map<ConditionID, ConditionData.BooleanCondition> bom = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.ByteCondition> bym = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.ShortCondition> shm = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.IntCondition> inm = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.LongCondition> lom = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.FloatCondition> flm = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.DoubleCondition> dom = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.CharCondition> chm = Maps.newConcurrentMap();
    private Map<ConditionID, ConditionData.StringCondition> stm = Maps.newConcurrentMap();

    public ConditionData.BooleanCondition getBooleanCondition(ConditionID id) {
        return this.getCondition(id, this.bom, ConditionData.BooleanCondition.EMPTY);
    }

    public ConditionData.ByteCondition getByteCondition(ConditionID id) {
        return this.getCondition(id, this.bym, ConditionData.ByteCondition.EMPTY);
    }

    public ConditionData.ShortCondition getShortCondition(ConditionID id) {
        return this.getCondition(id, this.shm, ConditionData.ShortCondition.EMPTY);
    }

    public ConditionData.IntCondition getIntCondition(ConditionID id) {
        return this.getCondition(id, this.inm, ConditionData.IntCondition.EMPTY);
    }

    public ConditionData.LongCondition getLongCondition(ConditionID id) {
        return this.getCondition(id, this.lom, ConditionData.LongCondition.EMPTY);
    }

    public ConditionData.FloatCondition getFloatCondition(ConditionID id) {
        return this.getCondition(id, this.flm, ConditionData.FloatCondition.EMPTY);
    }

    public ConditionData.DoubleCondition getDoubleCondition(ConditionID id) {
        return this.getCondition(id, this.dom, ConditionData.DoubleCondition.EMPTY);
    }

    public ConditionData.CharCondition getCharCondition(ConditionID id) {
        return this.getCondition(id, this.chm, ConditionData.CharCondition.EMPTY);
    }

    public ConditionData.StringCondition getStringCondition(ConditionID id) {
        return this.getCondition(id, this.stm, ConditionData.StringCondition.EMPTY);
    }

    private <T extends ConditionData> T getCondition(ConditionID id, Map<ConditionID, T> conditionMap, T empty) {
        if (conditionMap.containsKey(id)) {
            return (T)((ConditionData)conditionMap.get(id));
        }
        return empty;
    }

    public ConditionDataContainer copyScoped(ConditionScope scope) {
        Builder b = Builder.create();
        this.bom.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addBoolean(c.copy()));
        this.bym.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addByte(c.copy()));
        this.shm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addShort(c.copy()));
        this.inm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addInt(c.copy()));
        this.lom.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addLong(c.copy()));
        this.flm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addFloat(c.copy()));
        this.dom.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addDouble(c.copy()));
        this.chm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addChar(c.copy()));
        this.stm.values().stream().filter(c -> c.isValidScope(scope)).forEach(c -> b.addString(c.copy()));
        return b.build();
    }

    public ConditionDataContainer copy() {
        Builder b = Builder.create();
        this.bom.values().forEach(c -> b.addBoolean(c.copy()));
        this.bym.values().forEach(c -> b.addByte(c.copy()));
        this.shm.values().forEach(c -> b.addShort(c.copy()));
        this.inm.values().forEach(c -> b.addInt(c.copy()));
        this.lom.values().forEach(c -> b.addLong(c.copy()));
        this.flm.values().forEach(c -> b.addFloat(c.copy()));
        this.dom.values().forEach(c -> b.addDouble(c.copy()));
        this.chm.values().forEach(c -> b.addChar(c.copy()));
        this.stm.values().forEach(c -> b.addString(c.copy()));
        return b.build();
    }

    public void reloadFromTemplate(ConditionDataContainer template, boolean deleteUnspecified) {
        if (template == null) {
            throw new RuntimeException("Template is null!");
        }
        this.bom.forEach((id, c) -> {
            ConditionData.BooleanCondition ct = template.bom.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.bym.forEach((id, c) -> {
            ConditionData.ByteCondition ct = template.bym.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.shm.forEach((id, c) -> {
            ConditionData.ShortCondition ct = template.shm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.inm.forEach((id, c) -> {
            ConditionData.IntCondition ct = template.inm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.lom.forEach((id, c) -> {
            ConditionData.LongCondition ct = template.lom.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.flm.forEach((id, c) -> {
            ConditionData.FloatCondition ct = template.flm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.dom.forEach((id, c) -> {
            ConditionData.DoubleCondition ct = template.dom.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
        this.stm.forEach((id, c) -> {
            ConditionData.StringCondition ct = template.stm.get(id);
            if (ct != null) {
                c.applyParameters(ct);
            } else if (deleteUnspecified) {
                this.bom.remove(id);
            }
        });
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT bonbt = new CompoundNBT();
        this.bom.forEach((id, c) -> c.writeToNBT(bonbt));
        nbt.func_218657_a("booleans", (INBT)bonbt);
        CompoundNBT bynbt = new CompoundNBT();
        this.bym.forEach((id, c) -> c.writeToNBT(bynbt));
        nbt.func_218657_a("bytes", (INBT)bynbt);
        CompoundNBT shnbt = new CompoundNBT();
        this.shm.forEach((id, c) -> c.writeToNBT(shnbt));
        nbt.func_218657_a("shorts", (INBT)shnbt);
        CompoundNBT innbt = new CompoundNBT();
        this.inm.forEach((id, c) -> c.writeToNBT(innbt));
        nbt.func_218657_a("ints", (INBT)innbt);
        CompoundNBT lonbt = new CompoundNBT();
        this.lom.forEach((id, c) -> c.writeToNBT(lonbt));
        nbt.func_218657_a("longs", (INBT)lonbt);
        CompoundNBT flnbt = new CompoundNBT();
        this.flm.forEach((id, c) -> c.writeToNBT(flnbt));
        nbt.func_218657_a("floats", (INBT)flnbt);
        CompoundNBT donbt = new CompoundNBT();
        this.dom.forEach((id, c) -> c.writeToNBT(donbt));
        nbt.func_218657_a("doubles", (INBT)donbt);
        CompoundNBT chnbt = new CompoundNBT();
        this.chm.forEach((id, c) -> c.writeToNBT(chnbt));
        nbt.func_218657_a("chars", (INBT)chnbt);
        CompoundNBT stnbt = new CompoundNBT();
        this.stm.forEach((id, c) -> c.writeToNBT(stnbt));
        nbt.func_218657_a("strings", (INBT)stnbt);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        CompoundNBT bonbt = nbt.func_74775_l("booleans");
        this.bom.forEach((id, c) -> c.readFromNBT(bonbt));
        CompoundNBT bynbt = nbt.func_74775_l("bytes");
        this.bym.forEach((id, c) -> c.readFromNBT(bynbt));
        CompoundNBT shnbt = nbt.func_74775_l("shorts");
        this.shm.forEach((id, c) -> c.readFromNBT(shnbt));
        CompoundNBT innbt = nbt.func_74775_l("ints");
        this.inm.forEach((id, c) -> c.readFromNBT(innbt));
        CompoundNBT lonbt = nbt.func_74775_l("longs");
        this.lom.forEach((id, c) -> c.readFromNBT(lonbt));
        CompoundNBT flnbt = nbt.func_74775_l("floats");
        this.flm.forEach((id, c) -> c.readFromNBT(flnbt));
        CompoundNBT donbt = nbt.func_74775_l("doubles");
        this.dom.forEach((id, c) -> c.readFromNBT(donbt));
        CompoundNBT chnbt = nbt.func_74775_l("chars");
        this.chm.forEach((id, c) -> c.readFromNBT(chnbt));
        CompoundNBT stnbt = nbt.func_74775_l("strings");
        this.stm.forEach((id, c) -> c.readFromNBT(stnbt));
    }

    public static final class Builder {
        private Map<ConditionID, ConditionData.BooleanCondition> bom = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.ByteCondition> bym = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.ShortCondition> shm = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.IntCondition> inm = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.LongCondition> lom = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.FloatCondition> flm = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.DoubleCondition> dom = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.CharCondition> chm = Maps.newConcurrentMap();
        private Map<ConditionID, ConditionData.StringCondition> stm = Maps.newConcurrentMap();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public void addBoolean(ConditionData.BooleanCondition condition) {
            if (condition != null) {
                this.bom.put(condition.id, condition);
            }
        }

        public void addByte(ConditionData.ByteCondition condition) {
            if (condition != null) {
                this.bym.put(condition.id, condition);
            }
        }

        public void addShort(ConditionData.ShortCondition condition) {
            if (condition != null) {
                this.shm.put(condition.id, condition);
            }
        }

        public void addInt(ConditionData.IntCondition condition) {
            if (condition != null) {
                this.inm.put(condition.id, condition);
            }
        }

        public void addLong(ConditionData.LongCondition condition) {
            if (condition != null) {
                this.lom.put(condition.id, condition);
            }
        }

        public void addFloat(ConditionData.FloatCondition condition) {
            if (condition != null) {
                this.flm.put(condition.id, condition);
            }
        }

        public void addDouble(ConditionData.DoubleCondition condition) {
            if (condition != null) {
                this.dom.put(condition.id, condition);
            }
        }

        public void addChar(ConditionData.CharCondition condition) {
            if (condition != null) {
                this.chm.put(condition.id, condition);
            }
        }

        public void addString(ConditionData.StringCondition condition) {
            if (condition != null) {
                this.stm.put(condition.id, condition);
            }
        }

        public ConditionDataContainer build() {
            ConditionDataContainer cdb = new ConditionDataContainer();
            cdb.bom = this.bom;
            cdb.bym = this.bym;
            cdb.shm = this.shm;
            cdb.inm = this.inm;
            cdb.lom = this.lom;
            cdb.flm = this.flm;
            cdb.dom = this.dom;
            cdb.chm = this.chm;
            cdb.stm = this.stm;
            return cdb;
        }
    }
}

