/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.component;

import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.component.ComponentID;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public abstract class Component
implements Comparable<Component> {
    protected final ComponentID id;
    protected final boolean postPlacementStateUpdate;

    public Component(ComponentID id) {
        this.id = id;
        this.postPlacementStateUpdate = false;
    }

    public Component(ComponentID id, boolean stateUpdatePostPlacement) {
        this.id = id;
        this.postPlacementStateUpdate = stateUpdatePostPlacement;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Component && this.id.equals(((Component)obj).getID())) {
            return true;
        }
        return super.equals(obj);
    }

    public final ComponentID getID() {
        return this.id;
    }

    public boolean shouldUpdateStatePostPlacement() {
        return this.postPlacementStateUpdate;
    }

    public PlacementMode getPlacementMode() {
        return PlacementMode.AUTO;
    }

    public ItemStack getPlacementItem() {
        return ItemStack.field_190927_a;
    }

    public abstract boolean isValid(ItemStack var1);

    public abstract boolean isValid(TileEntity var1, XYZOrientation var2);

    public abstract BlockState validateState(BlockState var1, XYZOrientation var2);

    public String getUnlocalizedTypes() {
        return "component." + this.id.func_110624_b() + "." + this.id.getLocation() + ".types";
    }

    protected int getListPriority() {
        return 0;
    }

    @Override
    public final int compareTo(Component o) {
        if (this.getListPriority() == o.getListPriority()) {
            return 0;
        }
        if (this.getListPriority() > o.getListPriority()) {
            return -1;
        }
        return 1;
    }

    public static enum PlacementMode {
        NONE,
        AUTO,
        FAKE;

    }
}

