/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.autoutil;

public enum AutoMode {
    STOP(0, false, false),
    BUILD(1, false, true),
    PREVIEW(2, false, false),
    BREAK(3, true, false),
    BREAK_AND_BUILD(4, true, true);

    private final int index;
    private final boolean breakable;
    private final boolean buildable;

    private AutoMode(int index, boolean canBreak, boolean canBuild) {
        this.index = index;
        this.breakable = canBreak;
        this.buildable = canBuild;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean canBreak() {
        return this.breakable;
    }

    public boolean canBuild() {
        return this.buildable;
    }

    public static AutoMode fromIndex(int index) {
        switch (index) {
            case 1: {
                return BUILD;
            }
            case 2: {
                return PREVIEW;
            }
            case 3: {
                return BREAK;
            }
            case 4: {
                return BREAK_AND_BUILD;
            }
        }
        return STOP;
    }
}

