/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.TranslationTextComponent;

public class LocalizationUtils {
    private static final String SEPARATOR = ".";
    private static final String MOD_ID = "valkyrielib";

    public static TranslationTextComponent getLocalizedString(String mod_id, LocalizationType type, String id) {
        return new TranslationTextComponent(mod_id + SEPARATOR + type.getLocalizationBase() + SEPARATOR + id);
    }

    public static TranslationTextComponent getLocalizedString(LocalizationType type, String id) {
        return LocalizationUtils.getLocalizedString(MOD_ID, type, id);
    }

    public static TranslationTextComponent getLocalizedTextFromID(String id) {
        return LocalizationUtils.getLocalizedString(LocalizationType.TEXT, id);
    }

    public static TranslationTextComponent getLocalizedTextFromID(String mod_id, String id) {
        return LocalizationUtils.getLocalizedString(mod_id, LocalizationType.TEXT, id);
    }

    public static TranslationTextComponent getLocalizedButtonLabelFromID(String id) {
        return LocalizationUtils.getLocalizedString(LocalizationType.BUTTON_LABEL, id);
    }

    public static TranslationTextComponent getLocalizedButtonLabelFromID(String mod_id, String id) {
        return LocalizationUtils.getLocalizedString(mod_id, LocalizationType.BUTTON_LABEL, id);
    }

    public static TranslationTextComponent getLocalizedButtonToolTipFromID(String id) {
        return LocalizationUtils.getLocalizedString(LocalizationType.BUTTON_TOOL_TIP, id);
    }

    public static TranslationTextComponent getLocalizedButtonToolTipFromID(String mod_id, String id) {
        return LocalizationUtils.getLocalizedString(mod_id, LocalizationType.BUTTON_TOOL_TIP, id);
    }

    static enum LocalizationType {
        TEXT,
        BUTTON_LABEL,
        BUTTON_TOOL_TIP;

        private static final Map<LocalizationType, String> localizationBases;

        String getLocalizationBase() {
            return localizationBases.get((Object)this);
        }

        static {
            localizationBases = new HashMap<LocalizationType, String>(){
                {
                    this.put(TEXT, "text");
                    this.put(BUTTON_LABEL, "button.label");
                    this.put(BUTTON_TOOL_TIP, "button.tooltip");
                }
            };
        }
    }
}

