/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizable;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.client.gui.screen.Screen;

public final class GuiSizableBorder
extends GuiSizable {
    public GuiSizableBorder(VLID tex, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable, int textureWidth, int textureHeight) {
        super(tex, unitCornerX, unitCornerY, unitMiddleX, unitMiddleY, middleRepeatable, textureWidth, textureHeight);
        this.textures[1][1] = null;
    }

    @Override
    public void render(IElementContainer gui, MatrixStack matrixStack, Color4 color4, int x, int y, int w, int h) {
        GuiUtils.bindTexture(this.getResourceLocation());
        int middleW = w - 2 * this.getUnitCornerX();
        int middleH = h - 2 * this.getUnitCornerY();
        int tsy = y;
        int msy = y + this.getUnitCornerY();
        int bsy = y + (h - 1 * this.getUnitCornerY());
        int lsx = x;
        int msx = x + this.getUnitCornerX();
        int rsx = x + (w - 1 * this.getUnitCornerX());
        Screen guic = gui.getGui();
        GuiTexture topl = this.getGuiTexture(GuiSizable.SizableLocation.TOP_LEFT);
        GuiUtils.drawTexturedRect(matrixStack, color4, lsx, tsy, (float)topl.startX, (float)topl.startY, topl.width, topl.height, topl.getTexW(), topl.getTexH());
        GuiTexture topr = this.getGuiTexture(GuiSizable.SizableLocation.TOP_RIGHT);
        GuiUtils.drawTexturedRect(matrixStack, color4, rsx, tsy, (float)topr.startX, (float)topr.startY, topr.width, topr.height, topr.getTexW(), topr.getTexH());
        GuiTexture botl = this.getGuiTexture(GuiSizable.SizableLocation.BOT_LEFT);
        GuiUtils.drawTexturedRect(matrixStack, color4, lsx, bsy, (float)botl.startX, (float)botl.startY, botl.width, botl.height, botl.getTexW(), botl.getTexH());
        GuiTexture botr = this.getGuiTexture(GuiSizable.SizableLocation.BOT_RIGHT);
        GuiUtils.drawTexturedRect(matrixStack, color4, rsx, bsy, (float)botr.startX, (float)botr.startY, botr.width, botr.height, botr.getTexW(), botr.getTexH());
        if (this.getMiddleRepeatable()) {
            this.drawRepeatedMiddle(matrixStack, color4, middleW, middleH, tsy, msy, bsy, lsx, msx, rsx);
        } else {
            this.drawStretchedMiddle(matrixStack, color4, middleW, middleH, tsy, msy, bsy, lsx, msx, rsx);
        }
    }

    private void drawRepeatedMiddle(MatrixStack matrixStack, Color4 color4, int middleW, int middleH, int tsy, int msy, int bsy, int lsx, int msx, int rsx) {
        GuiTexture topm = this.getGuiTexture(GuiSizable.SizableLocation.TOP_MID);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color4, msx, tsy, topm.startX, topm.startY, topm.width, topm.height, middleW, this.getUnitCornerY(), topm.getTexW(), topm.getTexH());
        GuiTexture midl = this.getGuiTexture(GuiSizable.SizableLocation.MID_LEFT);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color4, lsx, msy, midl.startX, midl.startY, midl.width, midl.height, this.getUnitCornerX(), middleH, midl.getTexW(), midl.getTexH());
        GuiTexture midr = this.getGuiTexture(GuiSizable.SizableLocation.MID_RIGHT);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color4, rsx, msy, midr.startX, midr.startY, midr.width, midr.height, this.getUnitCornerX(), middleH, midr.getTexW(), midr.getTexH());
        GuiTexture botm = this.getGuiTexture(GuiSizable.SizableLocation.BOT_MID);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color4, msx, bsy, botm.startX, botm.startY, botm.width, botm.height, middleW, this.getUnitCornerY(), botm.getTexW(), botm.getTexH());
    }

    private void drawStretchedMiddle(MatrixStack matrixStack, Color4 color4, int middleW, int middleH, int tsy, int msy, int bsy, int lsx, int msx, int rsx) {
        GuiTexture topm = this.getGuiTexture(GuiSizable.SizableLocation.TOP_MID);
        GuiUtils.drawTexturedRect(matrixStack, color4, msx, tsy, topm.startX, topm.startY, topm.width, topm.height, middleW, this.getUnitCornerY(), topm.getTexW(), topm.getTexH());
        GuiTexture midl = this.getGuiTexture(GuiSizable.SizableLocation.MID_LEFT);
        GuiUtils.drawTexturedRect(matrixStack, color4, lsx, msy, midl.startX, midl.startY, midl.width, midl.height, this.getUnitCornerX(), middleH, midl.getTexW(), midl.getTexH());
        GuiTexture midr = this.getGuiTexture(GuiSizable.SizableLocation.MID_RIGHT);
        GuiUtils.drawTexturedRect(matrixStack, color4, rsx, msy, midr.startX, midr.startY, midr.width, midr.height, this.getUnitCornerX(), middleH, midr.getTexW(), midr.getTexH());
        GuiTexture botm = this.getGuiTexture(GuiSizable.SizableLocation.BOT_MID);
        GuiUtils.drawTexturedRect(matrixStack, color4, msx, bsy, botm.startX, botm.startY, botm.width, botm.height, middleW, this.getUnitCornerY(), botm.getTexW(), botm.getTexH());
    }

    public static GuiSizableBorder create(VLID loc, int x, int y, int uw, int uh) {
        return GuiSizableBorder.addParts(new GuiSizableBorder(loc, uw, uh, uw, uh, false, 256, 256), x, y);
    }

    public static GuiSizableBorder create(VLID loc, int x, int y, int uw, int uh, int textureWidth, int textureHeight) {
        return GuiSizableBorder.addParts(new GuiSizableBorder(loc, uw, uh, uw, uh, false, textureWidth, textureHeight), x, y);
    }

    public static GuiSizableBorder create(VLID loc, int textureX, int textureY, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable) {
        return GuiSizableBorder.addParts(new GuiSizableBorder(loc, unitCornerX, unitCornerY, unitMiddleX, unitMiddleY, middleRepeatable, 256, 256), textureX, textureY);
    }

    public static GuiSizableBorder create(VLID loc, int textureX, int textureY, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable, int textureWidth, int textureHeight) {
        return GuiSizableBorder.addParts(new GuiSizableBorder(loc, unitCornerX, unitCornerY, unitMiddleX, unitMiddleY, middleRepeatable, textureWidth, textureHeight), textureX, textureY);
    }

    private static GuiSizableBorder addParts(GuiSizableBorder sizableBox, int textureX, int textureY) {
        VLID loc = sizableBox.getResourceLocation();
        int x0 = textureX;
        int x1 = x0 + sizableBox.getUnitCornerX();
        int x2 = x1 + sizableBox.getUnitMiddleX();
        int x3 = x2 + sizableBox.getUnitCornerX();
        int y0 = textureY;
        int y1 = y0 + sizableBox.getUnitCornerY();
        int y2 = y1 + sizableBox.getUnitMiddleY();
        int y3 = y2 + sizableBox.getUnitCornerY();
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.TOP_LEFT, new GuiTexture(loc, x0, y0, x1, y1));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.TOP_MID, new GuiTexture(loc, x1, y0, x2, y1));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.TOP_RIGHT, new GuiTexture(loc, x2, y0, x3, y1));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.MID_LEFT, new GuiTexture(loc, x0, y1, x1, y2));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.MID, new GuiTexture(loc, x1, y1, x2, y2));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.MID_RIGHT, new GuiTexture(loc, x2, y1, x3, y2));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.BOT_LEFT, new GuiTexture(loc, x0, y2, x1, y3));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.BOT_MID, new GuiTexture(loc, x1, y2, x2, y3));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.BOT_RIGHT, new GuiTexture(loc, x2, y2, x3, y3));
        return sizableBox;
    }
}

