/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.image;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.ElementColor;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import net.minecraft.nbt.CompoundNBT;

public class ImageElement
extends VLElement
implements IElementDraw,
IElementThemeListener {
    protected AssetID imageID;
    protected GuiTexture image;
    protected HAlignment hAlignment;
    protected VAlignment vAlignment;
    protected int xSize;
    protected int ySize;
    protected boolean render = true;
    protected ElementColor color;

    public ImageElement(String id, AssetID imageID, AssetID colorID) {
        super(id);
        this.imageID = imageID;
        this.color = new ElementColor((IElement)this, colorID);
        this.hAlignment = HAlignment.LEFT;
        this.vAlignment = VAlignment.TOP;
    }

    public ImageElement(String id, AssetID imageID, Color4 color4) {
        super(id);
        this.imageID = imageID;
        this.color = new ElementColor((IElement)this, color4);
        this.hAlignment = HAlignment.LEFT;
        this.vAlignment = VAlignment.TOP;
    }

    public ImageElement(String id, AssetID imageID) {
        this(id, imageID, StandardThemeAssets.COL_DEFAULT_IMAGE_COLOR);
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    public ImageElement setVerticalAlignment(VAlignment va) {
        this.vAlignment = va;
        return this;
    }

    public ImageElement setHorizontalAlignment(HAlignment ha) {
        this.hAlignment = ha;
        return this;
    }

    public ImageElement setColor(AssetID colorID) {
        this.color.override(colorID);
        return this;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        if (!this.render) {
            return;
        }
        int xs = this.getSizeX();
        int ys = this.getSizeY();
        int xOffset = this.hAlignment.getOffset(xs);
        int yOffset = this.vAlignment.getOffset(ys);
        GuiUtils.drawGuiTexture(matrixStack, this.image, this.color.getColor(), this.getActualX() + xOffset, this.getActualY() + yOffset, xs, ys);
    }

    public void setImage(AssetID id) {
        this.imageID = id;
        if (this.image != null) {
            this.image = this.getContainer().getTheme().getTexture(id);
        }
    }

    public void setEnabled(boolean opt) {
        this.render = opt;
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.image = current.getTexture(this.imageID);
        this.xSize = this.image.width;
        this.ySize = this.image.height;
        this.color.onThemeChanged(current);
    }
}

