/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.infotablet.client.guide;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.infotablet.client.button.MainMenuButton;
import com.valkyrieofnight.vlib.core.infotablet.client.guide.AbstractGuideConstructor;
import com.valkyrieofnight.vlib.core.infotablet.client.page.AbstractInfoTabletPage;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.spacing.SpacingElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GridAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuideConstructorRegistry {
    private static GuideConstructorRegistry INST;
    private CopyOnWriteArrayList<AbstractGuideConstructor> constructors = Lists.newCopyOnWriteArrayList();

    public static GuideConstructorRegistry getInstance() {
        if (INST == null) {
            INST = new GuideConstructorRegistry();
        }
        return INST;
    }

    private GuideConstructorRegistry() {
        this.constructors.add(new AbstractGuideConstructor(new VLID("test", "page1")){

            @Override
            public Class<? extends AbstractInfoTabletPage> getPageClass() {
                return Test1.class;
            }

            @Override
            public MainMenuButton constructButton() {
                return new MainMenuButton("t", StandardThemeAssets.GSB_VANILLA_CREATIVE_TEXTFIELD, StandardThemeAssets.TEX_LOGO_DISCORD_BLU, (ITextComponent)new StringTextComponent("Title 1"), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
            }
        });
    }

    public void register(AbstractGuideConstructor constructor) {
        if (constructor == null) {
            throw new NullPointerException("Attempted to register null GuideConstructor");
        }
        this.constructors.add(constructor);
    }

    public List<AbstractGuideConstructor> getConstructors() {
        return this.constructors;
    }

    public List<AbstractInfoTabletPage> constructAll() {
        ArrayList pages = Lists.newArrayList();
        Collections.sort(this.constructors);
        for (AbstractGuideConstructor constructor : this.constructors) {
            pages.add(constructor.construct());
        }
        return pages;
    }

    public static class Test1
    extends AbstractInfoTabletPage {
        public Test1(String id) {
            super(id);
        }

        @Override
        public void addElements() {
            GridAlignment grid = new GridAlignment(120, 58, 1, 1, 3, Alignment.HORIZONTAL);
            for (int i = 0; i < 14; ++i) {
                SizablePanelElement sp1 = new SizablePanelElement("bg", StandardThemeAssets.GSB_VANILLA_CREATIVE_TEXTFIELD, 120, 58);
                this.addElement(sp1, 1 + grid.getCurrentXOffset(), 1 + grid.getCurrentYOffset());
                grid.next();
            }
            this.addElement(new LabelElement("test", (ITextComponent)new StringTextComponent("Page 1"), StandardThemeAssets.COL_CONTAINER_TITLE_TEXT), 30, 30);
            this.addElement(new SpacingElement("space", 0, 1), grid.getCurrentYOffset() - 1, 0);
        }
    }
}

