/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.impl.RankCommandPredicate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;

public class FTBRanksCommandManager {
    public static FTBRanksCommandManager INSTANCE;
    public final Map<String, RankCommandPredicate> commands = new HashMap<String, RankCommandPredicate>();
    public final Map<CommandNode<CommandSource>, RankCommandPredicate> commandNodes = new HashMap<CommandNode<CommandSource>, RankCommandPredicate>();

    public FTBRanksCommandManager(Commands c) {
        FTBRanks.LOGGER.info("Loading command nodes...");
        try {
            Field field = CommandNode.class.getDeclaredField("requirement");
            field.setAccessible(true);
            this.getCommandNodes((CommandDispatcher<CommandSource>)c.func_197054_a(), "command", field, (CommandNode<CommandSource>)c.func_197054_a().getRoot());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            FTBRanks.LOGGER.error("Reflection failed! Downgrading Java version to 8 might help");
        }
        FTBRanks.LOGGER.info("Loaded " + this.commands.size() + " command nodes");
    }

    private void getCommandNodes(CommandDispatcher<CommandSource> dispatcher, String perm, Field field, CommandNode<CommandSource> node) throws Exception {
        for (CommandNode c : node.getChildren()) {
            if (c.isFork()) continue;
            String n = perm + "." + c.getName().replace("*", "all");
            FTBRanks.LOGGER.debug(n);
            RankCommandPredicate predicate = new RankCommandPredicate((CommandNode<CommandSource>)c, n);
            field.set(c, predicate);
            this.commands.put(n, predicate);
            this.commandNodes.put((CommandNode<CommandSource>)c, predicate);
            this.getCommandNodes(dispatcher, n, field, (CommandNode<CommandSource>)c);
            if (c.getRedirect() == null || c.getRedirect() == dispatcher.getRoot()) continue;
            predicate.redirect = () -> this.commandNodes.get(c.getRedirect());
        }
    }
}

