/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.ItemStackTools;
import mcjty.xnet.compat.ForestrySupport;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemFilterCache {
    private boolean matchDamage = true;
    private boolean tagsMode = false;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private ItemStackList stacks;
    private Set<ResourceLocation> tagMatches = new HashSet<ResourceLocation>();

    public ItemFilterCache(boolean matchDamage, boolean tagsMode, boolean blacklistMode, boolean nbtMode, @Nonnull ItemStackList stacks) {
        this.matchDamage = matchDamage;
        this.tagsMode = tagsMode;
        this.blacklistMode = blacklistMode;
        this.nbtMode = nbtMode;
        this.stacks = stacks;
        for (ItemStack s : stacks) {
            ItemStackTools.addCommonTags((Collection)s.func_77973_b().getTags(), this.tagMatches);
        }
    }

    public boolean match(ItemStack stack) {
        if (!stack.func_190926_b()) {
            boolean match = false;
            if (this.tagsMode) {
                Set tags = stack.func_77973_b().getTags();
                if (tags.isEmpty()) {
                    match = this.itemMatches(stack);
                } else if (!Collections.disjoint(this.tagMatches, tags)) {
                    match = true;
                }
            } else {
                match = this.itemMatches(stack);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack) {
        if (this.stacks != null) {
            int forestryFlags = ForestrySupport.Tag.GEN.getFlag() | ForestrySupport.Tag.IS_ANALYZED.getFlag();
            ItemStack cleanedStack = null;
            if (this.nbtMode && ForestrySupport.isLoaded() && ForestrySupport.isBreedable(stack)) {
                cleanedStack = ForestrySupport.sanitize(stack, forestryFlags);
            }
            for (ItemStack itemStack : this.stacks) {
                ItemStack cleanedItemStack;
                if (this.matchDamage && itemStack.func_77952_i() != stack.func_77952_i() || this.nbtMode && (cleanedStack == null || !ForestrySupport.isBreedable(itemStack) ? !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack) : !ItemStack.func_77970_a((ItemStack)(cleanedItemStack = ForestrySupport.sanitize(itemStack, forestryFlags)), (ItemStack)cleanedStack)) || !itemStack.func_77973_b().equals(stack.func_77973_b())) continue;
                return true;
            }
        }
        return false;
    }
}

