/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.packets.magnet.PacketItemInfo;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetMessage;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.hooks.BasicEventHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class MagnetItem
extends Item {
    public MagnetItem(String registryName) {
        super(new Item.Properties().func_200916_a(SimpleMagnets.GROUP).func_200917_a(1));
        this.setRegistryName(registryName);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        MagnetItem.toggleMagnet(playerIn, stack);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static void toggleMagnet(PlayerEntity player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && stack.func_77973_b() instanceof MagnetItem) {
            boolean active = stack.func_196082_o().func_74764_b("active") && stack.func_196082_o().func_74767_n("active");
            stack.func_196082_o().func_74757_a("active", !active);
            SimpleMagnets.CHANNEL.sendToPlayer(player, (BasePacket)new PacketToggleMagnetMessage(active));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("active") && tag.func_74767_n("active")) {
            AxisAlignedBB area;
            int r;
            if (this.canPickupItems(tag)) {
                r = this.getRangeItems(tag);
                area = new AxisAlignedBB(entityIn.func_213303_ch().func_72441_c((double)(-r), (double)(-r), (double)(-r)), entityIn.func_213303_ch().func_72441_c((double)r, (double)r, (double)r));
                List items = worldIn.func_217394_a(EntityType.field_200765_E, area, item -> !(!item.func_70089_S() || worldIn.field_72995_K && item.field_70173_aa <= 1 || item.func_200214_m() != null && item.func_200214_m().equals(entityIn.func_110124_au()) && item.func_174874_s() || item.func_92059_d().func_190926_b() || item.getPersistentData().func_74764_b("PreventRemoteMovement") || !this.canPickupStack(tag, item.func_92059_d())));
                items.forEach(item -> item.func_70107_b(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_()));
                if (!worldIn.field_72995_K && entityIn instanceof PlayerEntity && ModList.get().isLoaded("itemphysic")) {
                    items.forEach(item -> MagnetItem.playerTouch(item, (PlayerEntity)entityIn));
                }
            }
            if (!worldIn.field_72995_K && this.canPickupXp(tag) && entityIn instanceof PlayerEntity) {
                r = this.getRangeXp(tag);
                area = new AxisAlignedBB(entityIn.func_213303_ch().func_72441_c((double)(-r), (double)(-r), (double)(-r)), entityIn.func_213303_ch().func_72441_c((double)r, (double)r, (double)r));
                PlayerEntity player = (PlayerEntity)entityIn;
                List orbs = worldIn.func_217357_a(ExperienceOrbEntity.class, area);
                orbs.forEach(orb -> {
                    orb.field_70532_c = 0;
                    player.field_71090_bL = 0;
                    orb.func_70100_b_(player);
                });
            }
        }
    }

    private static void playerTouch(ItemEntity itemEntity, PlayerEntity player) {
        if (!itemEntity.field_70170_p.field_72995_K) {
            if (itemEntity.func_174874_s()) {
                return;
            }
            ItemStack itemstack = itemEntity.func_92059_d();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)itemEntity, (PlayerEntity)player);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.func_77946_l();
            if (!(itemEntity.func_174874_s() || itemEntity.func_200215_l() != null && itemEntity.lifespan - itemEntity.func_174872_o() > 200 && !itemEntity.func_200215_l().equals(player.func_110124_au()) || hook != 1 && i > 0 && !player.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - itemstack.func_190916_E());
                BasicEventHooks.firePlayerItemPickupEvent((PlayerEntity)player, (ItemEntity)itemEntity, (ItemStack)copy);
                player.func_71001_a((Entity)itemEntity, i);
                if (itemstack.func_190926_b()) {
                    itemEntity.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                player.func_71064_a(Stats.field_199089_f.func_199076_b((Object)item), i);
                player.func_233630_a_(itemEntity);
            }
        }
    }

    protected abstract boolean canPickupItems(CompoundNBT var1);

    protected abstract boolean canPickupStack(CompoundNBT var1, ItemStack var2);

    protected abstract boolean canPickupXp(CompoundNBT var1);

    protected abstract int getRangeItems(CompoundNBT var1);

    protected abstract int getRangeXp(CompoundNBT var1);

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("active") && stack.func_196082_o().func_74767_n("active");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.getTooltip());
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    protected abstract ITextComponent getTooltip();

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking e) {
        if (!e.getPlayer().field_70170_p.field_72995_K && e.getTarget() instanceof ItemEntity && ((ItemEntity)e.getTarget()).func_200214_m() != null) {
            SimpleMagnets.CHANNEL.sendToPlayer(e.getPlayer(), (BasePacket)new PacketItemInfo((ItemEntity)e.getTarget()));
        }
    }
}

