/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.chiseling.preview.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.client.chiseling.preview.render.IChiselContextPreviewRenderer;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.util.StateEntryPredicates;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;

public class ConfigurableColoredVoxelShapeChiselContextPreviewRenderer
implements IChiselContextPreviewRenderer {
    static ResourceLocation ID = new ResourceLocation("chiselsandbits", "default");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void renderExistingContextsBoundingBox(MatrixStack matrixStack, IChiselingContext currentContextSnapshot) {
        if (!currentContextSnapshot.getMutator().isPresent()) {
            return;
        }
        Vector3d vector3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double xView = vector3d.func_82615_a();
        double yView = vector3d.func_82617_b();
        double zView = vector3d.func_82616_c();
        BlockPos inWorldStartPos = new BlockPos(currentContextSnapshot.getMutator().get().getInWorldStartPoint());
        VoxelShape boundingShape = VoxelShapeManager.getInstance().get(currentContextSnapshot.getMutator().get(), areaAccessor -> {
            Predicate<IStateEntryInfo> contextPredicate = currentContextSnapshot.getStateFilter().map(factory -> (Predicate)factory.apply(areaAccessor)).orElse(currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING ? StateEntryPredicates.NOT_AIR : StateEntryPredicates.ALL);
            return new InternalContextFilter(contextPredicate);
        }, false);
        List color = currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING ? (List)Configuration.getInstance().getClient().previewChiselingColor.get() : (List)Configuration.getInstance().getClient().previewPlacementColor.get();
        RenderSystem.disableDepthTest();
        WorldRenderer.func_228445_b_((MatrixStack)matrixStack, (IVertexBuilder)Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(ModRenderTypes.MEASUREMENT_LINES.get()), (VoxelShape)boundingShape, (double)((double)inWorldStartPos.func_177958_n() - xView), (double)((double)inWorldStartPos.func_177956_o() - yView), (double)((double)inWorldStartPos.func_177952_p() - zView), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 0, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 1, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 2, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 3, 1.0f));
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(ModRenderTypes.MEASUREMENT_LINES.get());
        RenderSystem.enableDepthTest();
    }

    private static float getColorValue(List<? extends Float> values, int index, float defaultValue) {
        if (values.size() <= index || index < 0) {
            return defaultValue;
        }
        Number value = values.get(index);
        if (0.0f <= value.floatValue() && value.floatValue() <= 1.0f) {
            return value.floatValue();
        }
        return defaultValue;
    }

    private static final class InternalContextFilter
    implements Predicate<IStateEntryInfo> {
        private final Predicate<IStateEntryInfo> placingContextPredicate;

        private InternalContextFilter(Predicate<IStateEntryInfo> placingContextPredicate) {
            this.placingContextPredicate = placingContextPredicate;
        }

        @Override
        public boolean test(IStateEntryInfo s) {
            return (s.getState().func_196958_f() || IEligibilityManager.getInstance().canBeChiseled(s.getState())) && this.placingContextPredicate.test(s);
        }

        public int hashCode() {
            return this.placingContextPredicate != null ? this.placingContextPredicate.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InternalContextFilter)) {
                return false;
            }
            InternalContextFilter that = (InternalContextFilter)o;
            return Objects.equals(this.placingContextPredicate, that.placingContextPredicate);
        }
    }
}

