/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class GroupingUtils {
    private GroupingUtils() {
        throw new IllegalStateException("Tried to initialize: GroupingUtils but this is a Utility class.");
    }

    public static <T, O> Collection<Collection<T>> groupByUsingSet(Iterable<T> source, Function<T, O> extractor) {
        return GroupingUtils.groupBy(HashMultimap.create(), source, extractor);
    }

    public static <T, O> Collection<Collection<T>> groupByUsingList(Iterable<T> source, Function<T, O> extractor) {
        return GroupingUtils.groupBy(ArrayListMultimap.create(), source, extractor);
    }

    private static <T, O> Collection<Collection<T>> groupBy(Multimap<O, T> groups, Iterable<T> source, Function<T, O> extractor) {
        source.forEach(e -> groups.put(extractor.apply(e), e));
        return groups.keySet().stream().map(arg_0 -> groups.get(arg_0)).collect(Collectors.toList());
    }

    public static <T, O> Map<O, Collection<T>> groupByUsingSetToMap(Iterable<T> source, Function<T, O> extractor) {
        return GroupingUtils.groupByToMap(HashMultimap.create(), source, extractor);
    }

    public static <T, O> Map<O, Collection<T>> groupByUsingListToMap(Iterable<T> source, Function<T, O> extractor) {
        return GroupingUtils.groupByToMap(ArrayListMultimap.create(), source, extractor);
    }

    private static <T, O> Map<O, Collection<T>> groupByToMap(Multimap<O, T> groups, Iterable<T> source, Function<T, O> extractor) {
        source.forEach(e -> groups.put(extractor.apply(e), e));
        return groups.asMap();
    }
}

