/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.config;

import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.config.ClientConfiguration;
import mod.chiselsandbits.api.config.CommonConfiguration;
import mod.chiselsandbits.api.config.ServerConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    private final ClientConfiguration clientConfig;
    private final ServerConfiguration serverConfig;
    private final CommonConfiguration commonConfig;
    private final ForgeConfigSpec clientConfigSpec;
    private final ForgeConfigSpec commonConfigSpec;
    private final ForgeConfigSpec serverConfigSpec;

    public static final Configuration getInstance() {
        return IChiselsAndBitsAPI.getInstance().getConfiguration();
    }

    public Configuration(ModContainer modContainer) {
        Pair cli = new ForgeConfigSpec.Builder().configure(ClientConfiguration::new);
        Pair ser = new ForgeConfigSpec.Builder().configure(ServerConfiguration::new);
        Pair com = new ForgeConfigSpec.Builder().configure(CommonConfiguration::new);
        ModConfig client = new ModConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)cli.getRight(), modContainer);
        ModConfig server = new ModConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)ser.getRight(), modContainer);
        ModConfig common = new ModConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)com.getRight(), modContainer);
        this.clientConfig = (ClientConfiguration)cli.getLeft();
        this.serverConfig = (ServerConfiguration)ser.getLeft();
        this.commonConfig = (CommonConfiguration)com.getLeft();
        this.clientConfigSpec = (ForgeConfigSpec)cli.getRight();
        this.serverConfigSpec = (ForgeConfigSpec)ser.getRight();
        this.commonConfigSpec = (ForgeConfigSpec)com.getRight();
        modContainer.addConfig(client);
        modContainer.addConfig(server);
        modContainer.addConfig(common);
    }

    public ClientConfiguration getClient() {
        return this.clientConfig;
    }

    public ServerConfiguration getServer() {
        return this.serverConfig;
    }

    public CommonConfiguration getCommon() {
        return this.commonConfig;
    }
}

