/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.network.IPacket;
import owmii.powah.block.ender.AbstractEnderTile;

public class SetChannelPacket
implements IPacket<SetChannelPacket> {
    private BlockPos pos;
    private int channel;

    public SetChannelPacket(BlockPos pos, int channel) {
        this.pos = pos;
        this.channel = channel;
    }

    public SetChannelPacket() {
        this(BlockPos.field_177992_a, 0);
    }

    public void encode(SetChannelPacket msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.pos);
        buffer.writeInt(msg.channel);
    }

    public SetChannelPacket decode(PacketBuffer buffer) {
        return new SetChannelPacket(buffer.func_179259_c(), buffer.readInt());
    }

    public void handle(SetChannelPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world;
            TileEntity te;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (te = (world = player.func_130014_f_()).func_175625_s(msg.pos)) instanceof AbstractEnderTile) {
                AbstractEnderTile cell = (AbstractEnderTile)te;
                cell.getChannel().set(msg.channel);
                cell.sync();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

