/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config.generator;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.lib.logistics.energy.Energy;
import owmii.powah.block.Tier;
import owmii.powah.config.EnergyConfig;

public class GeneratorConfig
extends EnergyConfig {
    public final Map<Tier, Long> generation = new HashMap<Tier, Long>();
    public final ForgeConfigSpec.LongValue starterGeneration;
    public final ForgeConfigSpec.LongValue basicGeneration;
    public final ForgeConfigSpec.LongValue hardenedGeneration;
    public final ForgeConfigSpec.LongValue blazingGeneration;
    public final ForgeConfigSpec.LongValue nioticGeneration;
    public final ForgeConfigSpec.LongValue spiritedGeneration;
    public final ForgeConfigSpec.LongValue nitroGeneration;

    public GeneratorConfig(ForgeConfigSpec.Builder builder, long[] caps, long[] trs, long[] gens) {
        super(builder, caps, trs);
        builder.push("Energy_Generation");
        this.starterGeneration = builder.defineInRange("starterGeneration", gens[0], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicGeneration = builder.defineInRange("basicGeneration", gens[1], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedGeneration = builder.defineInRange("hardenedGeneration", gens[2], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingGeneration = builder.defineInRange("blazingGeneration", gens[3], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticGeneration = builder.defineInRange("nioticGeneration", gens[4], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedGeneration = builder.defineInRange("spiritedGeneration", gens[5], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroGeneration = builder.defineInRange("nitroGeneration", gens[6], Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
    }

    @Override
    public void reload() {
        super.reload();
        this.generation.put(Tier.STARTER, (Long)this.starterGeneration.get());
        this.generation.put(Tier.BASIC, (Long)this.basicGeneration.get());
        this.generation.put(Tier.HARDENED, (Long)this.hardenedGeneration.get());
        this.generation.put(Tier.BLAZING, (Long)this.blazingGeneration.get());
        this.generation.put(Tier.NIOTIC, (Long)this.nioticGeneration.get());
        this.generation.put(Tier.SPIRITED, (Long)this.spiritedGeneration.get());
        this.generation.put(Tier.NITRO, (Long)this.nitroGeneration.get());
        this.generation.put(Tier.CREATIVE, Energy.MAX);
    }

    public long getGeneration(Tier variant) {
        if (this.generation.containsKey((Object)variant)) {
            return this.generation.get((Object)variant);
        }
        return 0L;
    }
}

