/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.storage;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.network.S2CNetMsg;

public class FluxNetworkData
extends WorldSavedData {
    private static final String NETWORK_DATA = "fluxnetworksdata";
    private static FluxNetworkData data;
    private static final String NETWORKS = "networks";
    private static final String TICKETS = "tickets";
    private static final String UNIQUE_ID = "uniqueID";
    private final Int2ObjectMap<IFluxNetwork> networks = new Int2ObjectOpenHashMap();
    private final Map<ResourceLocation, LongSet> tickets = new HashMap<ResourceLocation, LongSet>();
    private int uniqueID = 1;

    public FluxNetworkData() {
        super(NETWORK_DATA);
    }

    public static FluxNetworkData get() {
        if (data == null) {
            FluxNetworkData.load();
        }
        return data;
    }

    private static void load() {
        ServerWorld saveWorld = ServerLifecycleHooks.getCurrentServer().func_241755_D_();
        data = (FluxNetworkData)saveWorld.func_217481_x().func_215752_a(FluxNetworkData::new, NETWORK_DATA);
        FluxNetworks.LOGGER.info("FluxNetworkData has been successfully loaded");
    }

    public static void release() {
        if (data != null) {
            data = null;
            FluxNetworks.LOGGER.info("FluxNetworkData has been unloaded");
        }
    }

    @Nonnull
    public static IFluxNetwork getNetwork(int id) {
        return (IFluxNetwork)FluxNetworkData.get().networks.getOrDefault(id, (Object)FluxNetworkInvalid.INSTANCE);
    }

    @Nonnull
    public static Collection<IFluxNetwork> getAllNetworks() {
        return FluxNetworkData.get().networks.values();
    }

    @Nonnull
    public static LongSet getTickets(@Nonnull RegistryKey<World> dim) {
        return FluxNetworkData.get().tickets.computeIfAbsent(dim.func_240901_a_(), d -> new LongOpenHashSet());
    }

    @Nullable
    public IFluxNetwork createNetwork(@Nonnull PlayerEntity creator, String name, int color, SecurityType securityType, String password) {
        boolean limitReached;
        if (FluxConfig.maximumPerPlayer == -1) {
            limitReached = false;
        } else {
            UUID uuid = PlayerEntity.func_146094_a((GameProfile)creator.func_146103_bH());
            long created = this.networks.values().stream().filter(n -> n.getOwnerUUID().equals(uuid)).count();
            boolean bl = limitReached = created >= (long)FluxConfig.maximumPerPlayer;
        }
        if (limitReached) {
            return null;
        }
        FluxNetworkServer network = new FluxNetworkServer(this.uniqueID++, name, color, creator);
        network.getSecurity().set(securityType, password);
        if (this.networks.put(network.getNetworkID(), (Object)network) != null) {
            FluxNetworks.LOGGER.warn("Network IDs are not unique when creating network");
        }
        S2CNetMsg.updateNetwork(network, 21).sendToAll();
        return network;
    }

    public void deleteNetwork(@Nonnull IFluxNetwork network) {
        network.onDelete();
        this.networks.remove(network.getNetworkID());
        S2CNetMsg.updateNetwork(network, 29).sendToAll();
    }

    public boolean func_76188_b() {
        return true;
    }

    public void func_76184_a(@Nonnull CompoundNBT nbt) {
        this.uniqueID = nbt.func_74762_e(UNIQUE_ID);
        ListNBT list = nbt.func_150295_c(NETWORKS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            FluxNetworkServer network = new FluxNetworkServer();
            network.readCustomNBT(tag, 1);
            if (this.networks.put(network.getNetworkID(), (Object)network) == null) continue;
            FluxNetworks.LOGGER.warn("Network IDs are not unique when reading data");
        }
        CompoundNBT tag = nbt.func_74775_l(TICKETS);
        for (String key : tag.func_150296_c()) {
            ListNBT l2 = tag.func_150295_c(key, 4);
            LongSet set = this.tickets.computeIfAbsent(new ResourceLocation(key), d -> new LongOpenHashSet());
            for (INBT n : l2) {
                try {
                    set.add(((LongNBT)n).func_150291_c());
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        data = this;
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        compound.func_74768_a(UNIQUE_ID, this.uniqueID);
        ListNBT list = new ListNBT();
        for (IFluxNetwork network : this.networks.values()) {
            CompoundNBT tag = new CompoundNBT();
            network.writeCustomNBT(tag, 1);
            list.add((Object)tag);
        }
        compound.func_218657_a(NETWORKS, (INBT)list);
        CompoundNBT tag = new CompoundNBT();
        for (Map.Entry<ResourceLocation, LongSet> entry : this.tickets.entrySet()) {
            LongSet set = entry.getValue();
            if (set.isEmpty()) continue;
            ListNBT l2 = new ListNBT();
            LongIterator longIterator = set.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                l2.add((Object)LongNBT.func_229698_a_((long)l));
            }
            tag.func_218657_a(entry.getKey().toString(), (INBT)l2);
        }
        compound.func_218657_a(TICKETS, (INBT)tag);
        return compound;
    }
}

