/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

@OnlyIn(value=Dist.CLIENT)
public final class C2SNetMsg {
    private static final NetworkHandler sNetwork = NetworkHandler.sInstance;
    static final Functor[] sFunctors = new Functor[]{C2SNetMsg::tileEntity, C2SNetMsg::feedback, C2SNetMsg::updateSuperAdmin, C2SNetMsg::lavaEffect, C2SNetMsg::updateNetwork, C2SNetMsg::updateAccess, C2SNetMsg::updateConnection};

    public static void tileEntity(@Nonnull TileFluxDevice tile, byte type) {
        PacketBuffer buf = sNetwork.targetAt(0);
        buf.func_179255_a(tile.func_174877_v());
        buf.writeByte((int)type);
        tile.writePacket(buf, type);
        sNetwork.sendToServer(buf);
    }

    public static void requestSuperAdmin() {
        PacketBuffer buf = sNetwork.targetAt(1);
        sNetwork.sendToServer(buf);
    }

    public static void editMember(int networkID, UUID playerChanged, int type) {
        PacketBuffer buf = sNetwork.targetAt(2);
        buf.func_150787_b(networkID);
        buf.func_179252_a(playerChanged);
        buf.func_150787_b(type);
        sNetwork.sendToServer(buf);
    }

    public static void editNetwork(int networkID, String name, int color, @Nonnull SecurityType security, String password) {
        PacketBuffer buf = sNetwork.targetAt(3);
        buf.func_150787_b(networkID);
        buf.func_211400_a(name, 256);
        buf.writeInt(color);
        buf.func_150787_b(security.ordinal());
        buf.func_211400_a(password, 256);
        sNetwork.sendToServer(buf);
    }

    public static void editWireless(int networkID, int mode) {
        PacketBuffer buf = sNetwork.targetAt(4);
        buf.func_150787_b(networkID);
        buf.func_150787_b(mode);
        sNetwork.sendToServer(buf);
    }

    public static void requestNetworkUpdate(@Nonnull IFluxNetwork network, int type) {
        PacketBuffer buf = sNetwork.targetAt(5);
        buf.func_150787_b(type);
        buf.func_150787_b(1);
        buf.func_150787_b(network.getNetworkID());
        sNetwork.sendToServer(buf);
    }

    public static void requestNetworkUpdate(@Nonnull Collection<IFluxNetwork> networks, int type) {
        PacketBuffer buf = sNetwork.targetAt(5);
        buf.func_150787_b(type);
        buf.func_150787_b(networks.size());
        networks.forEach(net -> buf.func_150787_b(net.getNetworkID()));
        sNetwork.sendToServer(buf);
    }

    public static void setNetwork(BlockPos pos, int networkID, String password) {
        PacketBuffer buf = sNetwork.targetAt(6);
        buf.func_179255_a(pos);
        buf.func_150787_b(networkID);
        buf.func_211400_a(password, 256);
        sNetwork.sendToServer(buf);
    }

    public static void createNetwork(String name, int color, @Nonnull SecurityType security, String password) {
        PacketBuffer buf = sNetwork.targetAt(7);
        buf.func_211400_a(name, 256);
        buf.writeInt(color);
        buf.func_150787_b(security.ordinal());
        buf.func_211400_a(password, 256);
        sNetwork.sendToServer(buf);
    }

    public static void deleteNetwork(int networkID) {
        PacketBuffer buf = sNetwork.targetAt(8);
        buf.func_150787_b(networkID);
        sNetwork.sendToServer(buf);
    }

    public static void requestAccessUpdate(int networkID) {
        PacketBuffer buf = sNetwork.targetAt(9);
        buf.func_150787_b(networkID);
        sNetwork.sendToServer(buf);
    }

    public static void disconnect(int networkID, @Nonnull List<GlobalPos> list) {
        PacketBuffer buf = sNetwork.targetAt(10);
        buf.func_150787_b(networkID);
        buf.func_150787_b(64);
        buf.func_150787_b(list.size());
        list.forEach(pos -> FluxUtils.writeGlobalPos(buf, pos));
        sNetwork.sendToServer(buf);
    }

    public static void editConnections(int networkID, @Nonnull List<GlobalPos> list, int flags, String name, int priority, long limit, boolean surgeMode, boolean disableLimit, boolean chunkLoading) {
        PacketBuffer buf = sNetwork.targetAt(10);
        buf.func_150787_b(networkID);
        buf.func_150787_b(flags);
        buf.func_150787_b(list.size());
        list.forEach(pos -> FluxUtils.writeGlobalPos(buf, pos));
        if ((flags & 1) != 0) {
            buf.func_211400_a(name, 256);
        }
        if ((flags & 2) != 0) {
            buf.writeInt(priority);
        }
        if ((flags & 4) != 0) {
            buf.writeLong(limit);
        }
        if ((flags & 8) != 0) {
            buf.writeBoolean(surgeMode);
        }
        if ((flags & 0x10) != 0) {
            buf.writeBoolean(disableLimit);
        }
        if ((flags & 0x20) != 0) {
            buf.writeBoolean(chunkLoading);
        }
        sNetwork.sendToServer(buf);
    }

    public static void requestConnectionUpdate(int networkID, @Nonnull List<GlobalPos> list) {
        PacketBuffer buf = sNetwork.targetAt(11);
        buf.func_150787_b(networkID);
        buf.func_150787_b(list.size());
        list.forEach(pos -> FluxUtils.writeGlobalPos(buf, pos));
        sNetwork.sendToServer(buf);
    }

    public static void configuratorNet(int id, String password) {
        PacketBuffer buf = sNetwork.targetAt(12);
        buf.func_150787_b(id);
        buf.func_211400_a(password, 256);
        sNetwork.sendToServer(buf);
    }

    public static void configuratorEdit(String customName, CompoundNBT tag) {
        PacketBuffer buf = sNetwork.targetAt(13);
        buf.func_211400_a(customName, 256);
        buf.func_150786_a(tag);
        sNetwork.sendToServer(buf);
    }

    private static void tileEntity(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        TileEntity tile = player.field_70170_p.func_175625_s(buf.func_179259_c());
        if (tile instanceof TileFluxDevice) {
            ((TileFluxDevice)tile).readPacket(buf, buf.readByte());
        }
    }

    private static void feedback(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        FeedbackInfo info = FeedbackInfo.values()[buf.func_150792_a()];
        boolean action = info.action();
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!action) {
            FluxClientCache.setFeedbackText(info);
        } else if (screen instanceof GuiFluxCore) {
            ((GuiFluxCore)screen).onFeedbackAction(info);
        }
    }

    private static void updateSuperAdmin(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        FluxClientCache.superAdmin = buf.readBoolean();
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiFluxAdminHome) {
            ((GuiFluxAdminHome)screen).superAdmin.toggled = FluxClientCache.superAdmin;
        }
    }

    private static void lavaEffect(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        BlockPos pos = buf.func_179259_c();
        int count = buf.func_150792_a();
        ClientWorld world = player.field_213837_d;
        if (world != null) {
            for (int i = 0; i < count; ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void updateNetwork(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        int type = buf.func_150792_a();
        Int2ObjectArrayMap updatedNetworks = new Int2ObjectArrayMap();
        int size = buf.func_150792_a();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            updatedNetworks.put(buf.func_150792_a(), (Object)buf.func_150793_b());
        }
        FluxClientCache.updateNetworks((Int2ObjectMap<CompoundNBT>)updatedNetworks, type);
    }

    private static void updateAccess(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        AccessLevel access = AccessLevel.values()[buf.func_150792_a()];
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiFluxCore) {
            GuiFluxCore gui = (GuiFluxCore)screen;
            gui.accessLevel = access;
        }
    }

    private static void updateConnection(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
        int networkID = buf.func_150792_a();
        int size = buf.func_150792_a();
        ArrayList<CompoundNBT> tags = new ArrayList<CompoundNBT>();
        for (int i = 0; i < size; ++i) {
            tags.add(buf.func_150793_b());
        }
        FluxClientCache.updateConnections(networkID, tags);
    }

    @FunctionalInterface
    static interface Functor {
        public void f(@Nonnull PacketBuffer var1, @Nonnull ClientPlayerEntity var2);
    }
}

