/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popup.PopupCore;
import sonar.fluxnetworks.client.gui.popup.PopupCustomColor;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.misc.FluxUtils;

public abstract class GuiTabEditAbstract
extends GuiTabCore {
    public InvisibleButton redirectButton;
    protected List<ColorButton> colorButtons = Lists.newArrayList();
    protected SecurityType securityType;
    public ColorButton colorBtn;
    public FluxTextWidget nameField;
    public FluxTextWidget passwordField;

    public GuiTabEditAbstract(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
    }

    public abstract void onEditSettingsChanged();

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.colorButtons.clear();
        this.buttonLists.add(this.colorButtons);
        this.configureNavigationButtons(this.getNavigationTab(), this.navigationTabs);
        if (this.networkValid || this.getNavigationTab() == EnumNavigationTab.TAB_CREATE) {
            int l = this.field_230712_o_.func_78256_a(FluxTranslate.NETWORK_NAME.t());
            this.nameField = FluxTextWidget.create("", this.field_230712_o_, this.field_147003_i + 20 + l, this.field_147009_r + 28, 140 - l, 12);
            this.nameField.func_146203_f(24);
            this.nameField.func_212954_a(string -> this.onEditSettingsChanged());
            l = this.field_230712_o_.func_78256_a(FluxTranslate.NETWORK_PASSWORD.t());
            this.passwordField = FluxTextWidget.create("", this.field_230712_o_, this.field_147003_i + 20 + l, this.field_147009_r + 63, 140 - l, 12).setTextInvisible();
            this.passwordField.func_146203_f(16);
            this.passwordField.func_212954_a(string -> this.onEditSettingsChanged());
            this.passwordField.func_146189_e(this.securityType == SecurityType.ENCRYPTED);
            this.func_230480_a_((Widget)this.nameField);
            this.func_230480_a_((Widget)this.passwordField);
        } else if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
            this.func_230480_a_((Widget)this.redirectButton);
        }
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.getNavigationTab() == EnumNavigationTab.TAB_CREATE || this.networkValid) {
            this.drawCenterText(matrixStack, this.getNavigationTab().getTranslatedName(), 88.0f, 10.0f, 0xB4B4B4);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.NETWORK_NAME.t() + ":", 14.0f, 30.0f, 0x606060);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.NETWORK_SECURITY.t() + ": " + TextFormatting.AQUA + this.securityType.getName(), 14.0f, 50.0f, 0x606060);
            if (this.securityType == SecurityType.ENCRYPTED) {
                this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.NETWORK_PASSWORD.t() + ": ", 14.0f, 65.0f, 0x606060);
            }
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.NETWORK_COLOR.t() + ":", 14.0f, 92.0f, 0x606060);
        }
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && mouseX > (double)(this.field_147003_i + 50) && mouseX < (double)(this.field_147003_i + 150) && mouseY > (double)(this.field_147009_r + 48) && mouseY < (double)(this.getGuiTop() + 60)) {
            this.securityType = (SecurityType)FluxUtils.incrementEnum((Enum)this.securityType, (Enum[])SecurityType.values());
            this.passwordField.func_146180_a("");
            this.passwordField.func_146189_e(this.securityType == SecurityType.ENCRYPTED);
            this.onEditSettingsChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof ColorButton) {
            this.colorBtn.selected = false;
            this.colorBtn = (ColorButton)button;
            this.colorBtn.selected = true;
            this.onEditSettingsChanged();
            if (mouseButton == 1) {
                this.openPopUp(new PopupCustomColor(this, this.player, this.colorBtn.color));
            }
        }
    }

    @Override
    public void onPopUpClose(PopupCore<?> popUp) {
        super.onPopUpClose(popUp);
        if (popUp instanceof PopupCustomColor) {
            this.colorBtn.color = ((PopupCustomColor)popUp).currentColor;
        }
    }
}

