/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.GuiFluxConfiguratorHome;
import sonar.fluxnetworks.client.gui.GuiFluxDeviceHome;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.gui.button.NavigationButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.client.gui.tab.GuiTabCreate;
import sonar.fluxnetworks.client.gui.tab.GuiTabDetailedSelection;
import sonar.fluxnetworks.client.gui.tab.GuiTabMembers;
import sonar.fluxnetworks.client.gui.tab.GuiTabSelection;
import sonar.fluxnetworks.client.gui.tab.GuiTabSettings;
import sonar.fluxnetworks.client.gui.tab.GuiTabStatistics;
import sonar.fluxnetworks.client.gui.tab.GuiTabWireless;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.registry.RegistrySounds;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class GuiTabCore
extends GuiFluxCore {
    protected List<NavigationButton> navigationButtons = Lists.newArrayList();
    public EnumNavigationTab[] navigationTabs;

    public GuiTabCore(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.setDefaultTabs();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.navigationButtons.clear();
        this.buttonLists.add(this.navigationButtons);
    }

    public abstract EnumNavigationTab getNavigationTab();

    public void setDefaultTabs() {
        this.navigationTabs = EnumNavigationTab.values();
    }

    public void setNavigationTabs(EnumNavigationTab[] navigationTabs) {
        this.navigationTabs = navigationTabs;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof NavigationButton) {
            this.switchTab(((NavigationButton)button).tab);
            if (FluxConfig.enableButtonSound) {
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
            }
        }
    }

    public void configureNavigationButtons(EnumNavigationTab currentTab, @Nonnull EnumNavigationTab[] availableTabs) {
        int posCount = 0;
        for (EnumNavigationTab tab : availableTabs) {
            if (tab != EnumNavigationTab.TAB_CREATE) {
                this.navigationButtons.add(new NavigationButton(12 + 18 * posCount, -16, tab));
                ++posCount;
                continue;
            }
            this.navigationButtons.add(new NavigationButton(148, -16, tab));
        }
        this.navigationButtons.get(currentTab.ordinal()).setMain();
    }

    protected final void switchTab(@Nonnull EnumNavigationTab tab) {
        switch (tab) {
            case TAB_HOME: {
                if (((FluxMenu)this.field_147002_h).bridge instanceof TileFluxDevice) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiFluxDeviceHome((FluxMenu)this.field_147002_h, this.player));
                    break;
                }
                if (((FluxMenu)this.field_147002_h).bridge instanceof ItemFluxConfigurator.MenuBridge) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiFluxConfiguratorHome((FluxMenu)this.field_147002_h, this.player));
                    break;
                }
                if (((FluxMenu)this.field_147002_h).bridge instanceof ItemAdminConfigurator.MenuBridge) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiFluxAdminHome((FluxMenu)this.field_147002_h, this.player));
                    break;
                }
                this.func_231175_as__();
                break;
            }
            case TAB_SELECTION: {
                if (((FluxMenu)this.field_147002_h).bridge instanceof ItemAdminConfigurator.MenuBridge && FluxClientCache.detailedNetworkView) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabDetailedSelection((FluxMenu)this.field_147002_h, this.player));
                    break;
                }
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabSelection((FluxMenu)this.field_147002_h, this.player));
                break;
            }
            case TAB_WIRELESS: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabWireless((FluxMenu)this.field_147002_h, this.player));
                break;
            }
            case TAB_CONNECTION: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabConnections((FluxMenu)this.field_147002_h, this.player));
                break;
            }
            case TAB_STATISTICS: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabStatistics((FluxMenu)this.field_147002_h, this.player));
                break;
            }
            case TAB_MEMBER: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabMembers((FluxMenu)this.field_147002_h, this.player));
                break;
            }
            case TAB_SETTING: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabSettings((FluxMenu)this.field_147002_h, this.player));
                break;
            }
            case TAB_CREATE: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabCreate((FluxMenu)this.field_147002_h, this.player));
            }
        }
    }
}

