/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.connection.BasicFluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.misc.FluxUtils;

@OnlyIn(value=Dist.CLIENT)
public class FluxClientCache {
    private static final Int2ObjectMap<IFluxNetwork> NETWORKS = new Int2ObjectOpenHashMap();
    public static boolean superAdmin = false;
    public static boolean detailedNetworkView = false;
    public static int adminViewingNetwork = -1;
    private static FeedbackInfo feedback = FeedbackInfo.NONE;
    private static int feedbackTimer = 0;

    public static void release() {
        NETWORKS.clear();
    }

    public static void updateNetworks(@Nonnull Int2ObjectMap<CompoundNBT> serverSideNetworks, int type) {
        for (Int2ObjectMap.Entry entry : serverSideNetworks.int2ObjectEntrySet()) {
            int id = entry.getIntKey();
            CompoundNBT nbt = (CompoundNBT)entry.getValue();
            IFluxNetwork network = (IFluxNetwork)NETWORKS.get(id);
            if (type == 29) {
                if (network == null) continue;
                NETWORKS.remove(id);
                continue;
            }
            if (network == null) {
                network = new BasicFluxNetwork();
                network.readCustomNBT(nbt, type);
                NETWORKS.put(id, (Object)network);
                continue;
            }
            network.readCustomNBT(nbt, type);
        }
    }

    public static void updateConnections(int networkID, List<CompoundNBT> tags) {
        IFluxNetwork network = (IFluxNetwork)NETWORKS.get(networkID);
        if (network != null) {
            for (CompoundNBT tag : tags) {
                GlobalPos globalPos = FluxUtils.readGlobalPos(tag);
                network.getConnectionByPos(globalPos).ifPresent(c -> c.readCustomNBT(tag, 20));
            }
        }
    }

    @Nonnull
    public static IFluxNetwork getNetwork(int id) {
        return (IFluxNetwork)NETWORKS.getOrDefault(id, (Object)FluxNetworkInvalid.INSTANCE);
    }

    public static String getDisplayName(@Nonnull CompoundNBT subTag) {
        IFluxNetwork network = FluxClientCache.getNetwork(subTag.func_74762_e("networkID"));
        if (network.isValid()) {
            return network.getNetworkName();
        }
        return "NONE";
    }

    @Nonnull
    public static String getFeedbackText() {
        return feedback.getText();
    }

    public static int getFeedbackColor() {
        return 0xFF5555 | (int)((float)(Math.min(feedbackTimer, 16) * Math.min(61 - feedbackTimer, 5)) * 3.1875f) << 24;
    }

    public static void setFeedbackText(FeedbackInfo info) {
        feedback = info;
        feedbackTimer = feedbackTimer > 0 ? 58 : 60;
    }

    public static void tick() {
        if (feedback != FeedbackInfo.NONE && --feedbackTimer <= 0) {
            feedback = FeedbackInfo.NONE;
        }
    }

    @Nonnull
    public static List<IFluxNetwork> getAllNetworks() {
        return new ArrayList<IFluxNetwork>((Collection<IFluxNetwork>)NETWORKS.values());
    }
}

