/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.TileEntityBaseScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.ClientProxy;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.packets.PacketScreenRemoveChannel;
import com.supermartijn642.tesseract.packets.PacketScreenSetChannel;
import com.supermartijn642.tesseract.screen.InfoButton;
import com.supermartijn642.tesseract.screen.PlayerRenderer;
import com.supermartijn642.tesseract.screen.RedstoneButton;
import com.supermartijn642.tesseract.screen.TesseractAddChannelScreen;
import com.supermartijn642.tesseract.screen.TesseractButton;
import com.supermartijn642.tesseract.screen.TransferButton;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class TesseractScreen
extends TileEntityBaseScreen<TesseractTile> {
    private static final int MAX_DISPLAYED_CHANNELS = 12;
    private static final int CHANNEL_CUTOFF_LENGTH = 100;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tesseract", "textures/gui/new_gui.png");
    private static final int BACKGROUND_WIDTH = 249;
    private static final int BACKGROUND_HEIGHT = 211;
    private static final ResourceLocation CHANNEL_BACKGROUND = new ResourceLocation("tesseract", "textures/gui/background.png");
    private static final ResourceLocation TAB_ON = new ResourceLocation("tesseract", "textures/gui/tab_new.png");
    private static final ResourceLocation TAB_OFF = new ResourceLocation("tesseract", "textures/gui/tab_off_new.png");
    private static final ResourceLocation ITEM_ICON = new ResourceLocation("tesseract", "textures/gui/item_tab_icon.png");
    private static final ResourceLocation ENERGY_ICON = new ResourceLocation("tesseract", "textures/gui/energy_tab_icon.png");
    private static final ResourceLocation FLUID_ICON = new ResourceLocation("tesseract", "textures/gui/fluid_tab_icon.png");
    private static final ResourceLocation SCROLL_BUTTONS = new ResourceLocation("minecraft", "textures/gui/server_selection.png");
    private static final ResourceLocation LOCK_ON = new ResourceLocation("tesseract", "textures/gui/lock_on.png");
    private static final ResourceLocation LOCK_OFF = new ResourceLocation("tesseract", "textures/gui/lock_off.png");
    private static final ResourceLocation REDSTONE_TAB = new ResourceLocation("tesseract", "textures/gui/redstone_tab.png");
    private static final ResourceLocation SIDE_TAB = new ResourceLocation("tesseract", "textures/gui/side_tab_new.png");
    private static final ResourceLocation CHECKMARK = new ResourceLocation("tesseract", "textures/gui/checkmark_icon.png");
    private static EnumChannelType type = EnumChannelType.ITEMS;
    private TesseractButton setButton;
    private TesseractButton removeButton;
    private TransferButton transferButton;
    private RedstoneButton redstoneButton;
    private int selectedChannel = -1;
    private int scrollOffset = 0;

    protected float sizeX(TesseractTile tile) {
        return 249.0f;
    }

    protected float sizeY(TesseractTile tile) {
        return 211.0f;
    }

    public TesseractScreen(BlockPos pos) {
        super((ITextComponent)new TranslationTextComponent("gui.tesseract.title"), pos);
    }

    protected void addWidgets(TesseractTile tile) {
        this.setButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(113, 185, 61, 18, (ITextComponent)new TranslationTextComponent("gui.tesseract.set"), () -> {
            TesseractTile tile2 = (TesseractTile)((Object)((Object)this.getObjectOrClose()));
            if (tile2 != null) {
                if (tile2.getChannelId(type) == this.selectedChannel) {
                    Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenSetChannel(type, -1, this.tilePos));
                    this.setButton.setText((ITextComponent)new TranslationTextComponent("gui.tesseract.set"));
                } else {
                    Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenSetChannel(type, this.selectedChannel, this.tilePos));
                    this.setButton.setText((ITextComponent)new TranslationTextComponent("gui.tesseract.unset"));
                }
            }
        }));
        this.setButton.active = false;
        this.removeButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(180, 185, 61, 18, (ITextComponent)new TranslationTextComponent("gui.tesseract.remove"), () -> {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenRemoveChannel(type, this.selectedChannel));
            this.selectedChannel = -1;
            this.setButton.active = false;
            this.setButton.setText((ITextComponent)new TranslationTextComponent("gui.tesseract.set"));
            this.removeButton.active = false;
        }));
        this.removeButton.setRedBackground();
        this.removeButton.active = false;
        this.addWidget((Widget)new TesseractButton(29, 190, 50, 10, (ITextComponent)new TranslationTextComponent("gui.tesseract.add"), () -> ClientUtils.displayScreen((Screen)new TesseractAddChannelScreen(this.tilePos, type))));
        this.transferButton = (TransferButton)this.addWidget((Widget)new TransferButton(-21, 156));
        this.transferButton.update(tile, type);
        this.redstoneButton = (RedstoneButton)this.addWidget((Widget)new RedstoneButton(-25, 59));
        this.redstoneButton.update(tile);
        ((InfoButton)this.addWidget((Widget)new InfoButton((int)-25, (int)37, (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$addWidgets$3(), ()V)((TesseractScreen)this)))).active = false;
    }

    protected void tick(TesseractTile tile) {
        this.transferButton.update(tile, type);
        this.redstoneButton.update(tile);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        GlStateManager.func_227709_e_();
        GlStateManager.func_227740_m_();
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
        TranslationTextComponent s = new TranslationTextComponent("gui.tesseract." + type.name().toLowerCase(Locale.ROOT));
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)s, (float)177.0f, (float)14.0f, (int)-1);
        this.drawTabs(matrixStack);
        this.drawChannels(matrixStack, mouseX, mouseY, tile);
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, this.selectedChannel);
        if (channel != null) {
            this.drawSelectedChannelInfo(matrixStack, channel);
        }
    }

    protected void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
        for (int i = 0; i < 12 && i + this.scrollOffset < channels.size(); ++i) {
            String creatorName;
            Channel channel = channels.get(i + this.scrollOffset);
            int x = tile.getChannelId(type) == channel.id ? 17 : 5;
            int y = 31 + i * 13;
            if (mouseX < x || mouseX >= x + 9 || mouseY < y + 2 || mouseY >= y + 11 || (creatorName = PlayerRenderer.getPlayerUsername(channel.creator)) == null) continue;
            this.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(creatorName), mouseX, mouseY);
        }
        if (mouseX >= 9 && mouseX < 31 && mouseY >= (type == EnumChannelType.ITEMS ? 2 : 4) && mouseY < 28) {
            this.func_238652_a_(matrixStack, EnumChannelType.ITEMS.getTranslation(), mouseX, mouseY);
        } else if (mouseX >= 38 && mouseX < 60 && mouseY >= (type == EnumChannelType.ENERGY ? 2 : 4) && mouseY < 28) {
            this.func_238652_a_(matrixStack, EnumChannelType.ENERGY.getTranslation(), mouseX, mouseY);
        } else if (mouseX >= 67 && mouseX < 89 && mouseY >= (type == EnumChannelType.FLUID ? 2 : 4) && mouseY < 28) {
            this.func_238652_a_(matrixStack, EnumChannelType.FLUID.getTranslation(), mouseX, mouseY);
        }
    }

    private void drawTabs(MatrixStack matrixStack) {
        this.drawTab(matrixStack, EnumChannelType.ITEMS, 6, ITEM_ICON);
        this.drawTab(matrixStack, EnumChannelType.ENERGY, 35, ENERGY_ICON);
        this.drawTab(matrixStack, EnumChannelType.FLUID, 64, FLUID_ICON);
        ScreenUtils.bindTexture((ResourceLocation)SIDE_TAB);
        GlStateManager.func_227709_e_();
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)-27.0f, (float)150.0f, (float)30.0f, (float)32.0f);
        ScreenUtils.bindTexture((ResourceLocation)REDSTONE_TAB);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)-30.0f, (float)32.0f, (float)30.0f, (float)52.0f);
    }

    private void drawTab(MatrixStack matrixStack, EnumChannelType type, int x, ResourceLocation icon) {
        ScreenUtils.bindTexture((ResourceLocation)(type == TesseractScreen.type ? TAB_ON : TAB_OFF));
        GlStateManager.func_227709_e_();
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)x, (float)(type == TesseractScreen.type ? 0.0f : 2.0f), (float)28.0f, (float)(type == TesseractScreen.type ? 31.0f : 26.0f));
        float width = 16.0f;
        float height = 16.0f;
        float iconX = (float)x + (28.0f - width) / 2.0f;
        float iconY = (float)(TesseractScreen.type == type ? 0 : 2) + (29.0f - height) / 2.0f;
        this.field_230707_j_.func_175042_a(new ItemStack((IItemProvider)type.item.get()), (int)(this.left() + iconX), (int)(this.top() + iconY));
    }

    private void drawChannels(MatrixStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        ScreenUtils.bindTexture((ResourceLocation)CHANNEL_BACKGROUND);
        GlStateManager.func_227709_e_();
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)3.0f, (float)31.0f, (float)102.0f, (float)156.0f, (float)0.0f, (float)0.0f, (float)0.3984375f, (float)0.61328125f);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)26.0f, (float)187.0f, (float)56.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.21875f, (float)0.0625f);
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
        int channelHeight = 13;
        for (int i = 0; i < 12 && i + this.scrollOffset < channels.size(); ++i) {
            int x = 3;
            int y = 31 + i * channelHeight;
            Channel channel = channels.get(i + this.scrollOffset);
            if (tile.getChannelId(type) == channel.id) {
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)y, (float)102.0f, (float)channelHeight, (int)1761636432);
            }
            if (this.selectedChannel == channel.id) {
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)y, (float)102.0f, (float)1.0f, (int)-1);
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)(y + 12), (float)102.0f, (float)1.0f, (int)-1);
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)y, (float)1.0f, (float)channelHeight, (int)-1);
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)(x + 101), (float)y, (float)1.0f, (float)channelHeight, (int)-1);
            } else if (mouseX >= x && mouseX < 105 && mouseY >= y && mouseY < y + channelHeight) {
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)y, (float)102.0f, (float)1.0f, (int)-10066330);
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)(y + 12), (float)102.0f, (float)1.0f, (int)-10066330);
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)x, (float)y, (float)1.0f, (float)channelHeight, (int)-10066330);
                ScreenUtils.fillRect((MatrixStack)matrixStack, (float)(x + 101), (float)y, (float)1.0f, (float)channelHeight, (int)-10066330);
            }
            x += 2;
            if (tile.getChannelId(type) == channel.id) {
                ScreenUtils.bindTexture((ResourceLocation)CHECKMARK);
                ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)x, (float)(y + 2), (float)9.0f, (float)9.0f);
                x += 12;
            }
            PlayerRenderer.renderPlayerHead(channel.creator, matrixStack, x, y + 2, 9, 9);
            boolean isOwnedChannel = channel.creator.equals(ClientUtils.getPlayer().func_110124_au());
            int availableWidth = 100 - (x += 12) - (isOwnedChannel ? 9 : 0);
            String name = channel.name;
            if (this.field_230712_o_.func_78256_a(name) > availableWidth) {
                name = this.field_230712_o_.func_238420_b_().func_238361_b_(name, availableWidth - this.field_230712_o_.func_78256_a("..."), Style.field_240709_b_) + "...";
            }
            ScreenUtils.drawString((MatrixStack)matrixStack, (String)name, (float)x, (float)(y + 3), (int)-1);
            x += this.field_230712_o_.func_78256_a(name) + 3;
            if (!isOwnedChannel) continue;
            ScreenUtils.bindTexture((ResourceLocation)(channel.isPrivate ? LOCK_ON : LOCK_OFF));
            GlStateManager.func_227709_e_();
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)x, (float)(y + 2), (float)9.0f, (float)9.0f);
        }
    }

    private void drawSelectedChannelInfo(MatrixStack matrixStack, Channel channel) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(177.0, 35.0, 0.0);
        matrixStack.func_227862_a_(1.2f, 1.2f, 1.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (String)channel.name, (float)0.0f, (float)0.0f, (int)0xE0E0E0);
        matrixStack.func_227865_b_();
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new StringTextComponent("Creator:").func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true))), (float)117.0f, (float)55.0f, (int)-10066330);
        PlayerRenderer.renderPlayerHead(channel.creator, matrixStack, 117, 65, 9, 9);
        String creatorName = PlayerRenderer.getPlayerUsername(channel.creator);
        if (creatorName != null) {
            ScreenUtils.drawString((MatrixStack)matrixStack, (String)creatorName, (float)129.0f, (float)66.0f, (int)0xE0E0E0);
        }
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new StringTextComponent("Category:").func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true))), (float)117.0f, (float)80.0f, (int)-10066330);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227670_b_((double)(this.left() + 115.0f), (double)(this.top() + 88.0f), (double)0.0);
        GlStateManager.func_227672_b_((float)0.8f, (float)0.8f, (float)1.0f);
        this.field_230707_j_.func_175042_a(new ItemStack((IItemProvider)TesseractScreen.type.item.get()), 0, 0);
        GlStateManager.func_227627_O_();
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)channel.type.getTranslation(), (float)129.0f, (float)91.0f, (int)0xE0E0E0);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new StringTextComponent("Accessibility:").func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true))), (float)117.0f, (float)105.0f, (int)-10066330);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)(channel.isPrivate ? LOCK_ON : LOCK_OFF));
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)116.0f, (float)114.0f, (float)11.0f, (float)11.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.tesseract.channel." + (channel.isPrivate ? "private" : "public")), (float)129.0f, (float)116.0f, (int)0xE0E0E0);
    }

    private void setChannelType(EnumChannelType type) {
        TesseractScreen.type = type;
        this.scrollOffset = 0;
        this.selectedChannel = -1;
        this.setButton.active = false;
        this.setButton.setText((ITextComponent)new TranslationTextComponent("gui.tesseract.set"));
        this.removeButton.active = false;
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
        if (button == 0) {
            if (mouseY >= 2 && mouseY < 28) {
                if (mouseX >= 6 && mouseX < 34 && type != EnumChannelType.ITEMS) {
                    this.setChannelType(EnumChannelType.ITEMS);
                } else if (mouseX >= 35 && mouseX < 63 && type != EnumChannelType.ENERGY) {
                    this.setChannelType(EnumChannelType.ENERGY);
                } else if (mouseX >= 64 && mouseX < 92 && type != EnumChannelType.FLUID) {
                    this.setChannelType(EnumChannelType.FLUID);
                }
            } else if (mouseX >= 3 && mouseX < 105 && mouseY >= 31 && mouseY < 187) {
                int index = (mouseY - 31) / 13 + this.scrollOffset;
                List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
                if (index < channels.size()) {
                    TesseractTile tile = (TesseractTile)((Object)this.getObjectOrClose());
                    if (tile != null) {
                        this.selectedChannel = channels.get((int)index).id;
                        this.setButton.setText((ITextComponent)new TranslationTextComponent("gui.tesseract." + (tile.getChannelId(type) == this.selectedChannel ? "unset" : "set")));
                        this.setButton.active = true;
                        this.removeButton.active = channels.get((int)index).creator.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
                    }
                } else {
                    this.selectedChannel = -1;
                    this.setButton.active = false;
                    this.setButton.setText((ITextComponent)new TranslationTextComponent("gui.tesseract.set"));
                    this.removeButton.active = false;
                }
            }
        }
    }

    private void scroll(int amount) {
        if (TesseractChannelManager.CLIENT.getChannels(type).size() > 12) {
            this.scrollOffset = Math.max(this.scrollOffset + amount, 0);
            this.scrollOffset = Math.min(this.scrollOffset, TesseractChannelManager.CLIENT.getChannels(type).size() - 12);
        } else {
            this.scrollOffset = 0;
        }
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
        if (mouseX >= 15 && mouseX < 135 && mouseY >= 53 && mouseY < 196) {
            this.scroll(-((int)scroll));
        }
    }

    private /* synthetic */ void lambda$addWidgets$3() {
        ClientProxy.openInfoScreen(this.tilePos);
    }
}

