/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemKnockbackBelt
extends ItemBauble {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/belt_knockback.png");
    private static BipedModel<LivingEntity> model;

    public ItemKnockbackBelt(Item.Properties props) {
        super(props);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(ItemKnockbackBelt.getBaubleUUID(stack), "Knockback Belt", 1.0, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BipedModel<?> bipedModel, ItemStack stack, LivingEntity living, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AccessoryRenderHelper.rotateIfSneaking(ms, living);
        ms.func_227861_a_(0.0, (double)0.2f, 0.0);
        float s = 0.85f;
        ms.func_227862_a_(s, s, s);
        if (model == null) {
            model = new BipedModel(1.0f);
        }
        IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(texture));
        ItemKnockbackBelt.model.field_78115_e.func_228308_a_(ms, buffer, light, OverlayTexture.field_229196_a_);
    }
}

