/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityThornChakram
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<Integer> BOUNCES = EntityDataManager.func_187226_a(EntityThornChakram.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FLARE = EntityDataManager.func_187226_a(EntityThornChakram.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RETURN_TO = EntityDataManager.func_187226_a(EntityThornChakram.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int MAX_BOUNCES = 16;
    private boolean bounced = false;
    private ItemStack stack = ItemStack.field_190927_a;

    public EntityThornChakram(EntityType<EntityThornChakram> type, World world) {
        super(type, world);
    }

    public EntityThornChakram(LivingEntity e, World world, ItemStack stack) {
        super(ModEntities.THORN_CHAKRAM, e, world);
        this.stack = stack.func_77946_l();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
        this.field_70180_af.func_187214_a(FLARE, (Object)false);
        this.field_70180_af.func_187214_a(RETURN_TO, (Object)-1);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        Entity thrower;
        Vector3d old = this.func_213322_ci();
        super.func_70071_h_();
        if (!this.bounced) {
            this.func_213317_d(old);
        }
        this.bounced = false;
        if (this.isReturning() && (thrower = this.func_234616_v_()) != null) {
            Vector3 motion = Vector3.fromEntityCenter(thrower).subtract(Vector3.fromEntityCenter((Entity)this)).normalize();
            this.func_213317_d(motion.toVector3d());
        }
        if (this.field_70170_p.field_72995_K && this.isFire()) {
            double r = 0.1;
            double m = 0.1;
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + r * (Math.random() - 0.5), this.func_226278_cu_() + r * (Math.random() - 0.5), this.func_226281_cx_() + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5));
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.getTimesBounced() < 16 && this.field_70173_aa <= 60)) {
            thrower = this.func_234616_v_();
            if (thrower == null) {
                this.dropAndKill();
            } else {
                this.setEntityToReturnTo(thrower.func_145782_y());
                if (this.func_70068_e(thrower) < 2.0) {
                    this.dropAndKill();
                }
            }
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)item);
        this.func_70106_y();
    }

    private ItemStack getItemStack() {
        return !this.stack.func_190926_b() ? this.stack.func_77946_l() : (this.isFire() ? new ItemStack((IItemProvider)ModItems.flareChakram) : new ItemStack((IItemProvider)ModItems.thornChakram));
    }

    protected void func_70227_a(@Nonnull RayTraceResult pos) {
        if (this.isReturning()) {
            return;
        }
        switch (pos.func_216346_c()) {
            case BLOCK: {
                BlockRayTraceResult rtr = (BlockRayTraceResult)pos;
                Block block = this.field_70170_p.func_180495_p(rtr.func_216350_a()).func_177230_c();
                if (block instanceof BushBlock || block instanceof LeavesBlock) {
                    return;
                }
                int bounces = this.getTimesBounced();
                if (bounces >= 16) break;
                Vector3 currentMovementVec = new Vector3(this.func_213322_ci());
                Direction dir = rtr.func_216354_b();
                Vector3 normalVector = new Vector3(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()).normalize();
                Vector3 movementVec = normalVector.multiply(-2.0 * currentMovementVec.dotProduct(normalVector)).add(currentMovementVec);
                this.func_213317_d(movementVec.toVector3d());
                this.bounced = true;
                if (this.field_70170_p.field_72995_K) break;
                this.setTimesBounced(this.getTimesBounced() + 1);
                break;
            }
            case ENTITY: {
                EntityRayTraceResult rtr = (EntityRayTraceResult)pos;
                if (this.field_70170_p.field_72995_K || !(rtr.func_216348_a() instanceof LivingEntity) || rtr.func_216348_a() == this.func_234616_v_()) break;
                Entity thrower = this.func_234616_v_();
                DamageSource src = DamageSource.field_76377_j;
                if (thrower instanceof PlayerEntity) {
                    src = DamageSource.func_76356_a((Entity)this, (Entity)thrower);
                } else if (thrower instanceof LivingEntity) {
                    src = DamageSource.func_76358_a((LivingEntity)((LivingEntity)thrower));
                }
                rtr.func_216348_a().func_70097_a(src, 12.0f);
                if (this.isFire()) {
                    rtr.func_216348_a().func_70015_d(5);
                    break;
                }
                if (this.field_70170_p.field_73012_v.nextInt(3) != 0) break;
                ((LivingEntity)rtr.func_216348_a()).func_195064_c(new EffectInstance(Effects.field_76436_u, 60, 0));
                break;
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    private int getTimesBounced() {
        return (Integer)this.field_70180_af.func_187225_a(BOUNCES);
    }

    private void setTimesBounced(int times) {
        this.field_70180_af.func_187227_b(BOUNCES, (Object)times);
    }

    public boolean isFire() {
        return (Boolean)this.field_70180_af.func_187225_a(FLARE);
    }

    public void setFire(boolean fire) {
        this.field_70180_af.func_187227_b(FLARE, (Object)fire);
    }

    private boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    private int getEntityToReturnTo() {
        return (Integer)this.field_70180_af.func_187225_a(RETURN_TO);
    }

    private void setEntityToReturnTo(int entityID) {
        this.field_70180_af.func_187227_b(RETURN_TO, (Object)entityID);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.stack.func_190926_b()) {
            compound.func_218657_a("fly_stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a("flare", this.isFire());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("fly_stack")) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("fly_stack"));
        }
        this.setFire(compound.func_74767_n("flare"));
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return this.getItemStack();
    }
}

