/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class TileAvatar
extends TileSimpleInventory
implements IAvatarTile,
ITickableTileEntity {
    private static final int MAX_MANA = 6400;
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    private static final String TAG_MANA = "mana";
    private static final String TAG_COOLDOWNS = "boostCooldowns";
    private boolean enabled;
    private int ticksElapsed;
    private int mana;
    private final Map<UUID, Integer> boostCooldowns = new HashMap<UUID, Integer>();

    public TileAvatar() {
        super(ModTiles.AVATAR);
    }

    public void func_73660_a() {
        this.enabled = !this.field_145850_b.func_175640_z(this.field_174879_c);
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAvatarWieldable) {
            IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
            wieldable.onAvatarUpdate(this, stack);
        }
        if (this.enabled) {
            ++this.ticksElapsed;
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_74757_a(TAG_ENABLED, this.enabled);
        tag.func_74768_a(TAG_TICKS_ELAPSED, this.ticksElapsed);
        tag.func_74768_a(TAG_MANA, this.mana);
        ListNBT boostCooldowns = new ListNBT();
        for (Map.Entry<UUID, Integer> e : this.boostCooldowns.entrySet()) {
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_186854_a("id", e.getKey());
            cmp.func_74768_a("cooldown", e.getValue().intValue());
            boostCooldowns.add((Object)cmp);
        }
        tag.func_218657_a(TAG_COOLDOWNS, (INBT)boostCooldowns);
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.enabled = tag.func_74767_n(TAG_ENABLED);
        this.ticksElapsed = tag.func_74762_e(TAG_TICKS_ELAPSED);
        this.mana = tag.func_74762_e(TAG_MANA);
        this.boostCooldowns.clear();
        ListNBT boostCooldowns = tag.func_150295_c(TAG_COOLDOWNS, 10);
        for (INBT nbt : boostCooldowns) {
            CompoundNBT cmp = (CompoundNBT)nbt;
            UUID id = cmp.func_186857_a("id");
            int cooldown = cmp.func_74762_e("cooldown");
            this.boostCooldowns.put(id, cooldown);
        }
    }

    @Override
    protected Inventory createItemHandler() {
        return new Inventory(1){

            public int func_70297_j_() {
                return 1;
            }
        };
    }

    @Override
    public boolean isFull() {
        return this.mana >= 6400;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(19200, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.getItemHandler().func_70301_a(0).func_190926_b();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public IInventory getInventory() {
        return this.getItemHandler();
    }

    @Override
    public Direction getAvatarFacing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    @Override
    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Map<UUID, Integer> getBoostCooldowns() {
        return this.boostCooldowns;
    }
}

