/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.TileFakeAir;

public class SubTileBubbell
extends TileEntityFunctionalFlower {
    private static final int RANGE = 12;
    private static final int RANGE_MINI = 6;
    private static final int COST_PER_TICK = 4;
    private static final String TAG_RANGE = "range";
    int range = 2;

    public SubTileBubbell(TileEntityType<?> type) {
        super(type);
    }

    public SubTileBubbell() {
        this(ModSubtiles.BUBBELL);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.getMana() > 4) {
            this.addMana(-4);
            if (this.ticksExisted % 10 == 0 && this.range < this.getRange()) {
                ++this.range;
            }
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.getEffectivePos().func_177982_a(-this.range, -this.range, -this.range), (BlockPos)this.getEffectivePos().func_177982_a(this.range, this.range, this.range))) {
                BlockState state;
                if (!(this.getEffectivePos().func_177951_i((Vector3i)pos) < (double)(this.range * this.range)) || (state = this.func_145831_w().func_180495_p(pos)).func_185904_a() != Material.field_151586_h) continue;
                this.func_145831_w().func_180501_a(pos, ModBlocks.fakeAir.func_176223_P(), 2);
                TileFakeAir air = (TileFakeAir)this.func_145831_w().func_175625_s(pos);
                air.setFlower(this);
            }
        }
    }

    public static boolean isValidBubbell(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof SubTileBubbell) {
            return ((SubTileBubbell)tile).getMana() > 4;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_RANGE, this.range);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.range = cmp.func_74762_e(TAG_RANGE);
    }

    @Override
    public int getMaxMana() {
        return 2000;
    }

    @Override
    public int getColor() {
        return 905097;
    }

    public int getRange() {
        return 12;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.range);
    }

    public static class Mini
    extends SubTileBubbell {
        public Mini() {
            super(ModSubtiles.BUBBELL_CHIBI);
        }

        @Override
        public int getRange() {
            return 6;
        }
    }
}

