/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

public final class HUDHandler {
    public static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/mana_hud.png");

    private HUDHandler() {
    }

    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        IProfiler profiler = mc.func_213239_aq();
        ItemStack main = mc.field_71439_g.func_184614_ca();
        ItemStack offhand = mc.field_71439_g.func_184592_cb();
        MatrixStack ms = event.getMatrixStack();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            RayTraceResult pos;
            profiler.func_76320_a("botania-hud");
            if (Minecraft.func_71410_x().field_71442_b.func_78755_b()) {
                ItemStack dodgeRing;
                ItemStack tiara = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (LivingEntity)mc.field_71439_g);
                if (!tiara.func_190926_b()) {
                    profiler.func_76320_a("flugelTiara");
                    ItemFlightTiara.renderHUD(ms, (PlayerEntity)mc.field_71439_g, tiara);
                    profiler.func_76319_b();
                }
                if (!(dodgeRing = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, (LivingEntity)mc.field_71439_g)).func_190926_b()) {
                    profiler.func_76320_a("dodgeRing");
                    ItemDodgeRing.renderHUD(ms, (PlayerEntity)mc.field_71439_g, dodgeRing, event.getPartialTicks());
                    profiler.func_76319_b();
                }
            }
            if ((pos = mc.field_71476_x) != null) {
                TileEntity tile;
                BlockPos bpos = pos.func_216346_c() == RayTraceResult.Type.BLOCK ? ((BlockRayTraceResult)pos).func_216350_a() : null;
                BlockState state = bpos != null ? mc.field_71441_e.func_180495_p(bpos) : null;
                Block block = state == null ? null : state.func_177230_c();
                TileEntity tileEntity = tile = bpos != null ? mc.field_71441_e.func_175625_s(bpos) : null;
                if (PlayerHelper.hasAnyHeldItem((PlayerEntity)mc.field_71439_g)) {
                    if (PlayerHelper.hasHeldItem((PlayerEntity)mc.field_71439_g, ModItems.twigWand) && block instanceof IWandHUD) {
                        profiler.func_76320_a("wandItem");
                        ((IWandHUD)block).renderHUD(ms, mc, (World)mc.field_71441_e, bpos);
                        profiler.func_76319_b();
                    }
                    if (tile instanceof TilePool && !mc.field_71439_g.func_184614_ca().func_190926_b()) {
                        HUDHandler.renderPoolRecipeHUD(ms, (TilePool)tile, mc.field_71439_g.func_184614_ca());
                    }
                }
                if (!PlayerHelper.hasHeldItem((PlayerEntity)mc.field_71439_g, ModItems.lexicon)) {
                    if (tile instanceof TileAltar) {
                        ((TileAltar)tile).renderHUD(ms, mc);
                    } else if (tile instanceof TileRuneAltar) {
                        ((TileRuneAltar)tile).renderHUD(ms, mc);
                    } else if (tile instanceof TileCorporeaCrystalCube) {
                        HUDHandler.renderCrystalCubeHUD(ms, (TileCorporeaCrystalCube)tile);
                    }
                }
            }
            TileCorporeaIndex.getInputHandler();
            if (!TileCorporeaIndex.InputHandler.getNearbyIndexes((PlayerEntity)mc.field_71439_g).isEmpty() && mc.field_71462_r instanceof ChatScreen) {
                profiler.func_76320_a("nearIndex");
                HUDHandler.renderNearIndexDisplay(ms);
                profiler.func_76319_b();
            }
            if (!main.func_190926_b() && main.func_77973_b() instanceof ItemCraftingHalo) {
                profiler.func_76320_a("craftingHalo_main");
                ItemCraftingHalo.renderHUD(ms, (PlayerEntity)mc.field_71439_g, main);
                profiler.func_76319_b();
            } else if (!offhand.func_190926_b() && offhand.func_77973_b() instanceof ItemCraftingHalo) {
                profiler.func_76320_a("craftingHalo_off");
                ItemCraftingHalo.renderHUD(ms, (PlayerEntity)mc.field_71439_g, offhand);
                profiler.func_76319_b();
            }
            if (!main.func_190926_b() && main.func_77973_b() instanceof ItemSextant) {
                profiler.func_76320_a("sextant");
                ItemSextant.renderHUD(ms, (PlayerEntity)mc.field_71439_g, main);
                profiler.func_76319_b();
            }
            if (Botania.proxy.isClientPlayerWearingMonocle()) {
                profiler.func_76320_a("monocle");
                ItemMonocle.renderHUD(ms, (PlayerEntity)mc.field_71439_g);
                profiler.func_76319_b();
            }
            profiler.func_76320_a("manaBar");
            ClientPlayerEntity player = mc.field_71439_g;
            if (!player.func_175149_v()) {
                Item item;
                int totalMana = 0;
                int totalMaxMana = 0;
                boolean anyRequest = false;
                boolean creative = false;
                PlayerInventory mainInv = player.field_71071_by;
                IInventory accInv = BotaniaAPI.instance().getAccessoriesInventory((PlayerEntity)player);
                int invSize = mainInv.func_70302_i_();
                int size = invSize + accInv.func_70302_i_();
                for (int i = 0; i < size; ++i) {
                    boolean useAccessories = i >= invSize;
                    Object inv = useAccessories ? accInv : mainInv;
                    ItemStack stack = inv.func_70301_a(i - (useAccessories ? invSize : 0));
                    if (stack.func_190926_b() || !((item = stack.func_77973_b()) instanceof IManaUsingItem)) continue;
                    anyRequest = anyRequest || ((IManaUsingItem)item).usesMana(stack);
                }
                List<ItemStack> items = ManaItemHandler.instance().getManaItems((PlayerEntity)player);
                for (ItemStack stack : items) {
                    Item item2 = stack.func_77973_b();
                    if (!((IManaItem)item2).isNoExport(stack)) {
                        totalMana += ((IManaItem)item2).getMana(stack);
                        totalMaxMana += ((IManaItem)item2).getMaxMana(stack);
                    }
                    if (!(item2 instanceof ICreativeManaProvider) || !((ICreativeManaProvider)item2).isCreative(stack)) continue;
                    creative = true;
                }
                List<ItemStack> acc = ManaItemHandler.instance().getManaAccesories((PlayerEntity)player);
                for (ItemStack stack : acc) {
                    item = stack.func_77973_b();
                    if (!((IManaItem)item).isNoExport(stack)) {
                        totalMana += ((IManaItem)item).getMana(stack);
                        totalMaxMana += ((IManaItem)item).getMaxMana(stack);
                    }
                    if (!(item instanceof ICreativeManaProvider) || !((ICreativeManaProvider)item).isCreative(stack)) continue;
                    creative = true;
                }
                if (anyRequest) {
                    HUDHandler.renderManaInvBar(ms, creative, totalMana, totalMaxMana);
                }
            }
            profiler.func_219895_b("itemsRemaining");
            ItemsRemainingRenderHandler.render(ms, event.getPartialTicks());
            profiler.func_76319_b();
            profiler.func_76319_b();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void renderManaInvBar(MatrixStack ms, boolean hasCreative, int totalMana, int totalMaxMana) {
        Minecraft mc = Minecraft.func_71410_x();
        int width = 182;
        int x = mc.func_228018_at_().func_198107_o() / 2 - width / 2;
        int y = mc.func_228018_at_().func_198087_p() - (Integer)ConfigHandler.CLIENT.manaBarHeight.get();
        if (!hasCreative) {
            width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        }
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        int color = MathHelper.func_181758_c((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)Util.func_211177_b() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        mc.field_71446_o.func_110577_a(manaBar);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(ms, x, y, 0, 251, width, 5);
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderPoolRecipeHUD(MatrixStack ms, TilePool tile, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        IProfiler profiler = mc.func_213239_aq();
        profiler.func_76320_a("poolRecipe");
        IManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177977_b()));
        if (recipe != null) {
            int x = mc.func_228018_at_().func_198107_o() / 2 - 11;
            int y = mc.func_228018_at_().func_198087_p() / 2 + 10;
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.field_71439_g.func_200200_C_().getString().equals("haighyorkie") && mc.field_71439_g.func_225608_bj_() ? 23 : 8;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            mc.field_71446_o.func_110577_a(manaBar);
            RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_175599_af().func_180450_b(stack, x - 20, y);
            mc.func_175599_af().func_180450_b(recipe.func_77571_b(), x + 26, y);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, recipe.func_77571_b(), x + 26, y);
            RenderSystem.disableLighting();
            RenderSystem.disableBlend();
        }
        profiler.func_76319_b();
    }

    private static void renderCrystalCubeHUD(MatrixStack ms, TileCorporeaCrystalCube tile) {
        Minecraft mc = Minecraft.func_71410_x();
        IProfiler profiler = mc.func_213239_aq();
        profiler.func_76320_a("crystalCube");
        ItemStack target = tile.getRequestTarget();
        if (!target.func_190926_b()) {
            String s1 = target.func_200301_q().getString();
            String s2 = tile.getItemCount() + "x";
            int strlen = Math.max(mc.field_71466_p.func_78256_a(s1), mc.field_71466_p.func_78256_a(s2));
            int w = mc.func_228018_at_().func_198107_o();
            int h = mc.func_228018_at_().func_198087_p();
            int boxH = h / 2 + (tile.locked ? 20 : 10);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + strlen + 32), (int)boxH, (int)0x44000000);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + strlen + 34), (int)(boxH + 2), (int)0x44000000);
            mc.field_71466_p.func_238405_a_(ms, s1, (float)(w / 2 + 30), (float)(h / 2 - 10), 0x6666FF);
            mc.field_71466_p.func_238405_a_(ms, tile.getItemCount() + "x", (float)(w / 2 + 30), (float)(h / 2), 0xFFFFFF);
            if (tile.locked) {
                mc.field_71466_p.func_238405_a_(ms, I18n.func_135052_a((String)"botaniamisc.locked", (Object[])new Object[0]), (float)(w / 2 + 30), (float)(h / 2 + 10), 0xFFAA00);
            }
            RenderSystem.enableRescaleNormal();
            mc.func_175599_af().func_180450_b(target, w / 2 + 10, h / 2 - 10);
        }
        profiler.func_76319_b();
    }

    private static void renderNearIndexDisplay(MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        String txt0 = I18n.func_135052_a((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = TextFormatting.GRAY + I18n.func_135052_a((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = TextFormatting.GRAY + I18n.func_135052_a((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.field_71466_p.func_78256_a(txt0), Math.max(mc.field_71466_p.func_78256_a(txt1), mc.field_71466_p.func_78256_a(txt2))) + 20;
        int x = mc.func_228018_at_().func_198107_o() - l - 20;
        int y = mc.func_228018_at_().func_198087_p() - 60;
        AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x44000000);
        AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x44000000);
        RenderSystem.enableRescaleNormal();
        mc.func_175599_af().func_180450_b(new ItemStack((IItemProvider)ModBlocks.corporeaIndex), x, y + 10);
        mc.field_71466_p.func_238405_a_(ms, txt0, (float)(x + 20), (float)y, 0xFFFFFF);
        mc.field_71466_p.func_238405_a_(ms, txt1, (float)(x + 20), (float)(y + 14), 0xFFFFFF);
        mc.field_71466_p.func_238405_a_(ms, txt2, (float)(x + 20), (float)(y + 24), 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(MatrixStack ms, int color, int mana, int maxMana, String name) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.func_71410_x();
        int x = mc.func_228018_at_().func_198107_o() / 2 - mc.field_71466_p.func_78256_a(name) / 2;
        int y = mc.func_228018_at_().func_198087_p() / 2 + 10;
        mc.field_71466_p.func_238405_a_(ms, name, (float)x, (float)y, color);
        x = mc.func_228018_at_().func_198107_o() / 2 - 51;
        HUDHandler.renderManaBar(ms, x, y += 10, color, 1.0f, mana, maxMana);
        RenderSystem.disableBlend();
    }

    public static void drawComplexManaHUD(int color, MatrixStack ms, int mana, int maxMana, String name, ItemStack bindDisplay, boolean properlyBound) {
        HUDHandler.drawSimpleManaHUD(ms, color, mana, maxMana, name);
        Minecraft mc = Minecraft.func_71410_x();
        int x = mc.func_228018_at_().func_198107_o() / 2 + 55;
        int y = mc.func_228018_at_().func_198087_p() / 2 + 12;
        RenderSystem.enableRescaleNormal();
        mc.func_175599_af().func_180450_b(bindDisplay, x, y);
        RenderSystem.disableDepthTest();
        if (properlyBound) {
            mc.field_71466_p.func_238405_a_(ms, "\u2714", (float)(x + 10), (float)(y + 9), 19456);
            mc.field_71466_p.func_238405_a_(ms, "\u2714", (float)(x + 10), (float)(y + 8), 774669);
        } else {
            mc.field_71466_p.func_238405_a_(ms, "\u2718", (float)(x + 10), (float)(y + 9), 0x4C0000);
            mc.field_71466_p.func_238405_a_(ms, "\u2718", (float)(x + 10), (float)(y + 8), 13764621);
        }
        RenderSystem.enableDepthTest();
    }

    public static void renderManaBar(MatrixStack ms, int x, int y, int color, float alpha, int mana, int maxMana) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.field_71446_o.func_110577_a(manaBar);
        RenderHelper.drawTexturedModalRect(ms, x, y, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, 100, 3);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

