/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.proxy.block.network;

import com.buuz135.refinedstoragerequestify.proxy.CommonProxy;
import com.buuz135.refinedstoragerequestify.proxy.block.BlockCraftingEmitter;
import com.buuz135.refinedstoragerequestify.proxy.block.tile.TileCraftingEmitter;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeCraftingEmitter
extends NetworkNode
implements IType {
    public static final ResourceLocation ID = new ResourceLocation("rsrequestify", "crafting_emitter");
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilter";
    private BaseItemHandler itemFilter = new BaseItemHandler(9).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private FluidInventory fluidFilter = new FluidInventory(9).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private int type = 0;
    private ICraftingTask craftingTask = null;

    public NetworkNodeCraftingEmitter(World world, BlockPos pos) {
        super(world, pos);
    }

    public void update() {
        super.update();
        if (this.network == null) {
            return;
        }
        if (this.canUpdate() && this.ticks % 4 == 0 && (this.craftingTask == null || !this.network.getCraftingManager().getTasks().contains(this.craftingTask))) {
            int i;
            if (!(this.craftingTask == null || this.craftingTask.getCompletionPercentage() != 100 && this.network.getCraftingManager().getTasks().contains(this.craftingTask))) {
                this.craftingTask = null;
                this.updateState();
            }
            if (this.type == 0) {
                block0: for (ICraftingTask task : this.network.getCraftingManager().getTasks()) {
                    for (i = 0; i < this.itemFilter.getSlots(); ++i) {
                        if (task.getRequested().getItem() == null || !task.getRequested().getItem().func_77969_a(this.itemFilter.getStackInSlot(i))) continue;
                        this.craftingTask = task;
                        this.updateState();
                        continue block0;
                    }
                }
            }
            if (this.type == 1) {
                block2: for (ICraftingTask task : this.network.getCraftingManager().getTasks()) {
                    for (i = 0; i < this.fluidFilter.getSlots(); ++i) {
                        if (task.getRequested().getFluid() == null || !task.getRequested().getFluid().isFluidEqual(this.fluidFilter.getFluid(i))) continue;
                        this.craftingTask = task;
                        this.updateState();
                        continue block2;
                    }
                }
            }
        }
    }

    public ICraftingTask getCraftingTask() {
        return this.craftingTask;
    }

    public int getEnergyUsage() {
        return 10;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TileCraftingEmitter.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilter.writeToNbt());
        return tag;
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilter, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    private void updateState() {
        this.world.func_175656_a(this.pos, (BlockState)CommonProxy.CRAFTING_EMITTER.func_176223_P().func_206870_a((Property)BlockCraftingEmitter.POWERED, (Comparable)Boolean.valueOf(this.craftingTask != null)));
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = this.pos.func_177972_a(direction.func_176734_d());
            if (ForgeEventFactory.onNeighborNotify((World)this.world, (BlockPos)this.pos, (BlockState)this.world.func_180495_p(this.pos), EnumSet.of(direction.func_176734_d()), (boolean)false).isCanceled()) {
                return;
            }
            this.world.func_190524_a(blockpos, (Block)CommonProxy.CRAFTING_EMITTER, this.pos);
            this.world.func_175695_a(blockpos, (Block)CommonProxy.CRAFTING_EMITTER, direction);
        }
    }
}

