/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui;

import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.SoundMuffler;
import com.leobeliik.extremesoundmuffler.gui.buttons.MuffledSlider;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import com.leobeliik.extremesoundmuffler.utils.Tips;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class MainScreen
extends Screen
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private final List<Widget> filteredButtons = new ArrayList<Widget>();
    private static boolean isMuffling = true;
    private static String searchBarText = "";
    private static String screenTitle = "";
    private static ITextComponent toggleSoundsListMessage;
    private final int xSize = 256;
    private final int ySize = 202;
    private final boolean isAnchorsDisabled = Config.getDisableAchors();
    private final ITextComponent emptyText = StringTextComponent.field_240750_d_;
    private final String mainTitle = "ESM - Main Screen";
    private ITextComponent tip = ITextComponent.func_244388_a((String)Tips.randomTip());
    private int minYButton;
    private int maxYButton;
    private int index;
    private Button btnToggleMuffled;
    private Button btnDelete;
    private Button btnToggleSoundsList;
    private Button btnSetAnchor;
    private Button btnEditAnchor;
    private Button btnNextSounds;
    private Button btnPrevSounds;
    private Button btnAccept;
    private Button btnCancel;
    private TextFieldWidget searchBar;
    private TextFieldWidget editAnchorTitleBar;
    private TextFieldWidget editAnchorRadiusBar;
    private Anchor anchor;

    private MainScreen() {
        super(StringTextComponent.field_240750_d_);
    }

    private static void open(String title, ITextComponent message, String searchMessage) {
        toggleSoundsListMessage = message;
        screenTitle = title;
        searchBarText = searchMessage;
        minecraft.func_147108_a((Screen)new MainScreen());
    }

    public static void open() {
        MainScreen.open("ESM - Main Screen", ITextComponent.func_244388_a((String)"Recent"), "");
    }

    private void bindTexture() {
        minecraft.func_110434_K().func_110577_a(SoundMuffler.getGui());
    }

    public static boolean isMuffled() {
        return isMuffling;
    }

    @Nullable
    public static Anchor getAnchorByName(String name) {
        return anchorList.stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
    }

    @ParametersAreNonnullByDefault
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        this.bindTexture();
        this.func_238474_b_(matrix, this.getX(), this.getY(), 0, 0, 256, 202);
        MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)screenTitle, (int)(this.getX() + 128), (int)(this.getY() + 8), (int)0xFFFFFF);
        this.renderButtonsTextures(matrix, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        MainScreen.minecraft.field_195559_v.func_197967_a(true);
        this.minYButton = this.getY() + 46;
        this.maxYButton = this.getY() + 164;
        this.btnToggleSoundsList = new Button(this.getX() + 13, this.getY() + 181, 52, 13, toggleSoundsListMessage, b -> {
            boolean isAnchorMuffling = false;
            if (!screenTitle.equals("ESM - Main Screen")) {
                boolean bl = isAnchorMuffling = !Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)).getMuffledSounds().isEmpty();
            }
            toggleSoundsListMessage = this.btnToggleSoundsList.func_230458_i_().equals(ITextComponent.func_244388_a((String)"Recent")) ? ITextComponent.func_244388_a((String)"All") : (this.btnToggleSoundsList.func_230458_i_().equals(ITextComponent.func_244388_a((String)"All")) ? (!muffledSounds.isEmpty() || isAnchorMuffling ? ITextComponent.func_244388_a((String)"Muffled") : ITextComponent.func_244388_a((String)"Recent")) : ITextComponent.func_244388_a((String)"Recent"));
            this.btnToggleSoundsList.func_238482_a_(toggleSoundsListMessage);
            this.field_230710_m_.clear();
            MainScreen.open(screenTitle, toggleSoundsListMessage, this.searchBar.func_146179_b());
        });
        this.func_230481_d_((IGuiEventListener)this.btnToggleSoundsList);
        this.addSoundButtons();
        this.addAnchorButtons();
        this.btnToggleMuffled = new Button(this.getX() + 229, this.getY() + 179, 17, 17, this.emptyText, b -> {
            isMuffling = !isMuffling;
        });
        ((Button)this.func_230481_d_((IGuiEventListener)this.btnToggleMuffled)).func_230986_a_(0.0f);
        this.btnDelete = new Button(this.getX() + 205, this.getY() + 179, 17, 17, this.emptyText, b -> {
            this.anchor = MainScreen.getAnchorByName(screenTitle);
            if (this.clearRecentSounds()) {
                recentSoundsList.clear();
                if (screenTitle.equals("ESM - Main Screen")) {
                    MainScreen.open("ESM - Main Screen", this.btnToggleSoundsList.func_230458_i_(), this.searchBar.func_146179_b());
                } else if (this.anchor != null) {
                    MainScreen.open(this.anchor.getName(), this.btnToggleSoundsList.func_230458_i_(), this.searchBar.func_146179_b());
                }
                return;
            }
            if (screenTitle.equals("ESM - Main Screen")) {
                muffledSounds.clear();
                MainScreen.open("ESM - Main Screen", this.btnToggleSoundsList.func_230458_i_(), this.searchBar.func_146179_b());
            } else if (this.anchor != null) {
                this.anchor.deleteAnchor();
                this.field_230710_m_.clear();
                MainScreen.open(this.anchor.getName(), this.btnToggleSoundsList.func_230458_i_(), this.searchBar.func_146179_b());
            }
        });
        ((Button)this.func_230481_d_((IGuiEventListener)this.btnDelete)).func_230986_a_(0.0f);
        this.btnSetAnchor = new Button(this.getX() + 260, this.getY() + 62, 11, 11, this.emptyText, b -> Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)).setAnchor());
        ((Button)this.func_230481_d_((IGuiEventListener)this.btnSetAnchor)).func_230986_a_(0.0f);
        this.btnEditAnchor = new Button(this.getX() + 274, this.getY() + 62, 11, 11, this.emptyText, b -> this.editTitle(Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle))));
        ((Button)this.func_230481_d_((IGuiEventListener)this.btnEditAnchor)).func_230986_a_(0.0f);
        this.addEditAnchorButtons();
        if (screenTitle.equals("ESM - Main Screen")) {
            this.btnSetAnchor.field_230694_p_ = false;
            this.btnEditAnchor.field_230694_p_ = false;
        }
        this.searchBar = new TextFieldWidget(this.field_230712_o_, this.getX() + 74, this.getY() + 183, 119, 13, this.emptyText);
        this.func_230480_a_((Widget)this.searchBar);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146191_b(searchBarText);
        this.btnPrevSounds = new Button(this.getX() + 10, this.getY() + 22, 13, 20, this.emptyText, b -> this.listScroll(this.searchBar.func_146179_b().length() > 0 ? this.filteredButtons : this.field_230710_m_, -1.0));
        this.func_230481_d_((IGuiEventListener)this.btnPrevSounds);
        this.btnNextSounds = new Button(this.getX() + 233, this.getY() + 22, 13, 20, this.emptyText, b -> this.listScroll(this.searchBar.func_146179_b().length() > 0 ? this.filteredButtons : this.field_230710_m_, 1.0));
        this.func_230481_d_((IGuiEventListener)this.btnNextSounds);
        this.updateText();
    }

    private void addSoundButtons() {
        int buttonH = this.minYButton;
        this.anchor = MainScreen.getAnchorByName(screenTitle);
        if (!screenTitle.equals("ESM - Main Screen") && this.anchor == null) {
            return;
        }
        if (this.btnToggleSoundsList.func_230458_i_().equals(ITextComponent.func_244388_a((String)"Recent"))) {
            soundsList.clear();
            if (screenTitle.equals("ESM - Main Screen") && !muffledSounds.isEmpty()) {
                soundsList.addAll(muffledSounds.keySet());
            } else if (this.anchor != null && !this.anchor.getMuffledSounds().isEmpty()) {
                soundsList.addAll(this.anchor.getMuffledSounds().keySet());
            }
            soundsList.addAll(recentSoundsList);
        } else if (this.btnToggleSoundsList.func_230458_i_().equals(ITextComponent.func_244388_a((String)"All"))) {
            soundsList.clear();
            soundsList.addAll(ForgeRegistries.SOUND_EVENTS.getKeys());
            if (Config.getLawfulAllList()) {
                forbiddenSounds.forEach(fs -> soundsList.removeIf(sl -> sl.toString().contains((CharSequence)fs)));
            }
        } else {
            soundsList.clear();
            if (screenTitle.equals("ESM - Main Screen") && !muffledSounds.isEmpty()) {
                soundsList.addAll(muffledSounds.keySet());
            } else if (this.anchor != null && !this.anchor.getMuffledSounds().isEmpty()) {
                soundsList.addAll(this.anchor.getMuffledSounds().keySet());
            }
        }
        if (soundsList.isEmpty()) {
            return;
        }
        for (ResourceLocation sound : soundsList) {
            boolean muffledScreen;
            float maxVolume = 1.0f;
            float volume = screenTitle.equals("ESM - Main Screen") ? (muffledSounds.get(sound) == null ? maxVolume : ((Float)muffledSounds.get(sound)).floatValue()) : (this.anchor != null ? (this.anchor.getMuffledSounds().get(sound) == null ? maxVolume : ((Float)this.anchor.getMuffledSounds().get(sound)).floatValue()) : maxVolume);
            int x = Config.getLeftButtons() ? this.getX() + 36 : this.getX() + 11;
            MuffledSlider volumeSlider = new MuffledSlider(x, buttonH, 205, 11, volume, sound, screenTitle, this.anchor);
            boolean muffledAnchor = this.anchor != null && screenTitle.equals(this.anchor.getName()) && !this.anchor.getMuffledSounds().isEmpty() && this.anchor.getMuffledSounds().containsKey(sound);
            boolean bl = muffledScreen = screenTitle.equals("ESM - Main Screen") && !muffledSounds.isEmpty() && muffledSounds.containsKey(sound);
            if (muffledAnchor || muffledScreen) {
                volumeSlider.setFGColor(65535);
            }
            buttonH += volumeSlider.func_238483_d_() + 2;
            this.func_230480_a_(volumeSlider);
            volumeSlider.field_230694_p_ = this.field_230710_m_.indexOf(volumeSlider) < this.index + 10;
            this.func_230481_d_((IGuiEventListener)volumeSlider.getBtnToggleSound());
            this.func_230481_d_((IGuiEventListener)volumeSlider.getBtnPlaySound());
        }
    }

    private void addAnchorButtons() {
        int buttonW = this.getX() + 30;
        for (int i = 0; i <= 9; ++i) {
            Button btnAnchor;
            if (this.isAnchorsDisabled) {
                String[] disabledMsg = new String[]{"-", "D", "i", "s", "a", "b", "l", "e", "d", "-"};
                btnAnchor = new Button(buttonW, this.getY() + 24, 16, 16, ITextComponent.func_244388_a((String)disabledMsg[i]), b -> {});
                btnAnchor.field_230693_o_ = false;
            } else {
                int finalI = i;
                btnAnchor = new Button(buttonW, this.getY() + 24, 16, 16, ITextComponent.func_244388_a((String)String.valueOf(i)), b -> {
                    this.anchor = (Anchor)anchorList.get(finalI);
                    if (this.anchor == null) {
                        return;
                    }
                    screenTitle = screenTitle.equals(this.anchor.getName()) ? "ESM - Main Screen" : this.anchor.getName();
                    this.field_230710_m_.clear();
                    MainScreen.open(screenTitle, this.btnToggleSoundsList.func_230458_i_(), this.searchBar.func_146179_b());
                });
                if (!anchorList.isEmpty()) {
                    btnAnchor.setFGColor(((Anchor)anchorList.get(Integer.parseInt(btnAnchor.func_230458_i_().getString()))).getAnchorPos() != null ? 65280 : 0xFFFFFF);
                }
            }
            ((Button)this.func_230480_a_((Widget)btnAnchor)).func_230986_a_(0.0f);
            buttonW += 20;
        }
    }

    private void addEditAnchorButtons() {
        this.editAnchorTitleBar = new TextFieldWidget(this.field_230712_o_, this.getX() + 302, this.btnEditAnchor.field_230691_m_ + 20, 84, 11, this.emptyText);
        ((TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.getX() + 302, this.btnEditAnchor.field_230691_m_ + 20, 84, 11, this.emptyText))).field_230694_p_ = false;
        this.editAnchorRadiusBar = new TextFieldWidget(this.field_230712_o_, this.getX() + 302, this.editAnchorTitleBar.field_230691_m_ + 15, 30, 11, this.emptyText);
        ((TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.getX() + 302, this.editAnchorTitleBar.field_230691_m_ + 15, 30, 11, this.emptyText))).field_230694_p_ = false;
        this.btnAccept = new Button(this.getX() + 259, this.editAnchorRadiusBar.field_230691_m_ + 15, 40, 20, ITextComponent.func_244388_a((String)"Accept"), b -> {
            this.anchor = MainScreen.getAnchorByName(screenTitle);
            if (!this.editAnchorTitleBar.func_146179_b().isEmpty() && !this.editAnchorRadiusBar.func_146179_b().isEmpty() && this.anchor != null) {
                int Radius = Integer.parseInt(this.editAnchorRadiusBar.func_146179_b());
                if (Radius > 32) {
                    Radius = 32;
                } else if (Radius < 1) {
                    Radius = 1;
                }
                this.anchor.editAnchor(this.editAnchorTitleBar.func_146179_b(), Radius);
                screenTitle = this.editAnchorTitleBar.func_146179_b();
                this.editTitle(this.anchor);
            }
        });
        ((Button)this.func_230480_a_((Widget)new Button(this.getX() + 259, this.editAnchorRadiusBar.field_230691_m_ + 15, 40, 20, ITextComponent.func_244388_a((String)"Accept"), b -> {
            this.anchor = MainScreen.getAnchorByName(screenTitle);
            if (!this.editAnchorTitleBar.func_146179_b().isEmpty() && !this.editAnchorRadiusBar.func_146179_b().isEmpty() && this.anchor != null) {
                int Radius = Integer.parseInt(this.editAnchorRadiusBar.func_146179_b());
                if (Radius > 32) {
                    Radius = 32;
                } else if (Radius < 1) {
                    Radius = 1;
                }
                this.anchor.editAnchor(this.editAnchorTitleBar.func_146179_b(), Radius);
                screenTitle = this.editAnchorTitleBar.func_146179_b();
                this.editTitle(this.anchor);
            }
        }))).field_230694_p_ = false;
        this.btnCancel = new Button(this.getX() + 300, this.editAnchorRadiusBar.field_230691_m_ + 15, 40, 20, ITextComponent.func_244388_a((String)"Cancel"), b -> this.editTitle(Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle))));
        ((Button)this.func_230480_a_((Widget)new Button(this.getX() + 300, this.editAnchorRadiusBar.field_230691_m_ + 15, 40, 20, ITextComponent.func_244388_a((String)"Cancel"), b -> this.editTitle(Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)))))).field_230694_p_ = false;
    }

    private void renderButtonsTextures(MatrixStack matrix, double mouseX, double mouseY, float partialTicks) {
        if (this.field_230710_m_.size() < soundsList.size()) {
            return;
        }
        int x = this.btnDelete.field_230690_l_ + 8;
        int y = this.btnDelete.field_230691_m_;
        String message = screenTitle.equals("ESM - Main Screen") ? "Delete Muffled List" : "Delete Anchor";
        int stringW = this.field_230712_o_.func_78256_a(message) / 2;
        if (this.btnDelete.func_231047_b_(mouseX, mouseY)) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - stringW - 2), (int)(y + 17), (int)(x + stringW + 2), (int)(y + 30), (int)darkBG);
            MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)message, (int)x, (int)(y + 19), (int)0xFFFFFF);
        }
        if (this.clearRecentSounds()) {
            this.bindTexture();
            MainScreen.func_238463_a_((MatrixStack)matrix, (int)(x - 6), (int)(y + 2), (float)54.0f, (float)217.0f, (int)13, (int)13, (int)256, (int)256);
            message = "Clear recent sounds list";
            stringW = this.field_230712_o_.func_78256_a(message) / 2;
            if (this.btnDelete.func_231047_b_(mouseX, mouseY)) {
                MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - stringW - 2), (int)(y + 17), (int)(x + stringW + 2), (int)(y + 30), (int)darkBG);
                MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)message, (int)x, (int)(y + 19), (int)0xFFFFFF);
            }
        }
        x = this.btnToggleMuffled.field_230690_l_ + 8;
        y = this.btnToggleMuffled.field_230691_m_;
        this.bindTexture();
        if (isMuffling) {
            MainScreen.func_238463_a_((MatrixStack)matrix, (int)(x - 7), (int)(y + 1), (float)54.0f, (float)202.0f, (int)15, (int)15, (int)256, (int)256);
        }
        message = isMuffling ? "Stop Muffling" : "Start Muffling";
        stringW = this.field_230712_o_.func_78256_a(message) / 2;
        if (this.btnToggleMuffled.func_231047_b_(mouseX, mouseY)) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - stringW - 2), (int)(y + 18), (int)(x + stringW + 2), (int)(y + 30), (int)darkBG);
            MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)message, (int)x, (int)(y + 20), (int)0xFFFFFF);
        }
        Anchor anchor = MainScreen.getAnchorByName(screenTitle);
        String dimensionName = "";
        x = this.btnSetAnchor.field_230690_l_;
        y = this.btnSetAnchor.field_230691_m_;
        if (anchor != null) {
            String Radius;
            stringW = this.field_230712_o_.func_78256_a("Dimension: ");
            String string = Radius = anchor.getRadius() == 0 ? "" : String.valueOf(anchor.getRadius());
            if (anchor.getDimension() != null) {
                stringW += this.field_230712_o_.func_78256_a(anchor.getDimension().func_110623_a());
                dimensionName = anchor.getDimension().func_110623_a();
            }
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - 5), (int)(y - 56), (int)(x + stringW + 6), (int)(y + 16), (int)darkBG);
            MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)("X: " + anchor.getX()), (int)(x + 1), (int)(y - 50), (int)0xFFFFFF);
            MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)("Y: " + anchor.getY()), (int)(x + 1), (int)(y - 40), (int)0xFFFFFF);
            MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)("Z: " + anchor.getZ()), (int)(x + 1), (int)(y - 30), (int)0xFFFFFF);
            MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)("Radius: " + Radius), (int)(x + 1), (int)(y - 20), (int)0xFFFFFF);
            MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)("Dimension: " + dimensionName), (int)(x + 1), (int)(y - 10), (int)0xFFFFFF);
            this.bindTexture();
            MainScreen.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)69.45f, (int)11, (int)11, (int)88, (int)88);
            if (anchor.getAnchorPos() != null) {
                this.btnEditAnchor.field_230693_o_ = true;
                MainScreen.func_238463_a_((MatrixStack)matrix, (int)this.btnEditAnchor.field_230690_l_, (int)this.btnEditAnchor.field_230691_m_, (float)32.0f, (float)213.0f, (int)11, (int)11, (int)256, (int)256);
            } else {
                this.btnEditAnchor.field_230693_o_ = false;
            }
            for (Widget button : this.field_230710_m_) {
                if (button instanceof MuffledSlider) {
                    if (!((MuffledSlider)button).getBtnToggleSound().func_231047_b_(mouseX, mouseY) || anchor.getAnchorPos() != null) continue;
                    MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - 5), (int)(y + 16), (int)(x + 65), (int)(y + 40), (int)darkBG);
                    this.field_230712_o_.func_238421_b_(matrix, "Set the", (float)x, (float)(y + 18), 0xFFFFFF);
                    this.field_230712_o_.func_238421_b_(matrix, "Anchor first", (float)x, (float)(y + 29), 0xFFFFFF);
                    continue;
                }
                if (!button.func_230458_i_().getString().equals(String.valueOf(anchor.getAnchorId()))) continue;
                MainScreen.func_238463_a_((MatrixStack)matrix, (int)(button.field_230690_l_ - 5), (int)(button.field_230691_m_ - 2), (float)71.0f, (float)202.0f, (int)27, (int)22, (int)256, (int)256);
                break;
            }
        }
        message = "Set Anchor";
        stringW = this.field_230712_o_.func_78256_a(message) + 2;
        if (this.btnSetAnchor.func_230449_g_() && !this.editAnchorTitleBar.field_230694_p_) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - 5), (int)(y + 16), (int)(x + stringW), (int)(y + 29), (int)darkBG);
            this.field_230712_o_.func_238421_b_(matrix, message, (float)x, (float)(y + 18), 0xFFFFFF);
        }
        message = "Edit Anchor";
        stringW = this.field_230712_o_.func_78256_a(message) + 2;
        if (this.btnEditAnchor.field_230694_p_ && !this.editAnchorTitleBar.field_230694_p_ && this.btnEditAnchor.func_230449_g_()) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - 5), (int)(y + 16), (int)(x + stringW + 2), (int)(y + 29), (int)darkBG);
            this.field_230712_o_.func_238421_b_(matrix, message, (float)x, (float)(y + 18), 0xFFFFFF);
        }
        for (int i = 0; i <= 9; ++i) {
            Widget button;
            button = (Widget)this.field_230710_m_.get(soundsList.size() + i);
            x = button.field_230690_l_ + 8;
            y = button.field_230691_m_ + 5;
            message = this.isAnchorsDisabled ? "Anchors are disabled" : ((Anchor)anchorList.get(i)).getName();
            stringW = this.field_230712_o_.func_78256_a(message) / 2;
            if (!button.func_230449_g_()) continue;
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - stringW - 2), (int)(y - 2), (int)(x + stringW + 2), (int)(y - 13), (int)darkBG);
            MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)message, (int)x, (int)(y - 11), (int)0xFFFFFF);
        }
        x = this.btnToggleSoundsList.field_230690_l_;
        y = this.btnToggleSoundsList.field_230691_m_;
        message = this.btnToggleSoundsList.func_230458_i_().getString();
        int centerText = x + this.btnToggleSoundsList.func_230998_h_() / 2 - this.field_230712_o_.func_78256_a(message) / 2;
        this.field_230712_o_.func_238421_b_(matrix, message, (float)centerText, (float)(y + 3), 0);
        String text = "Showing " + message + " sounds";
        int textW = this.field_230712_o_.func_78256_a(text);
        int textX = x + this.btnToggleSoundsList.func_230998_h_() / 2 - textW / 2 + 6;
        if (this.btnToggleSoundsList.func_231047_b_(mouseX, mouseY)) {
            this.field_230712_o_.getClass();
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(textX - 2), (int)(y + 14), (int)(textX + textW + 2), (int)(y + 18 + 9), (int)darkBG);
            this.field_230712_o_.func_238421_b_(matrix, text, (float)textX, (float)(y + 16), 0xFFFFFF);
        }
        x = this.btnSetAnchor.field_230690_l_;
        y = this.editAnchorTitleBar.field_230691_m_;
        if (this.editAnchorRadiusBar.field_230694_p_) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - 4), (int)(y - 4), (int)(this.editAnchorTitleBar.field_230690_l_ + this.editAnchorTitleBar.func_230998_h_() + 3), (int)(this.btnAccept.field_230691_m_ + 23), (int)darkBG);
            this.field_230712_o_.func_238421_b_(matrix, "Title: ", (float)(x - 2), (float)(y + 1), 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrix, "Radius: ", (float)(x - 2), (float)(this.editAnchorRadiusBar.field_230691_m_ + 1), 0xFFFFFF);
            x = this.editAnchorRadiusBar.field_230690_l_ + this.editAnchorRadiusBar.func_230998_h_();
            y = this.editAnchorRadiusBar.field_230691_m_;
            message = "Range: 1 - 32";
            stringW = this.field_230712_o_.func_78256_a(message);
            if (this.editAnchorRadiusBar.func_230449_g_()) {
                MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x + 3), (int)y, (int)(x + stringW + 6), (int)(y + 12), (int)darkBG);
                this.field_230712_o_.func_238421_b_(matrix, message, (float)(x + 5), (float)(y + 2), 0xFFFFFF);
            }
        }
        x = this.searchBar.field_230690_l_;
        y = this.searchBar.field_230691_m_;
        IFormattableTextComponent searchHint = new TranslationTextComponent("gui.recipebook.search_hint").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY);
        if (!this.searchBar.func_230999_j_() && this.searchBar.func_146179_b().isEmpty()) {
            MainScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)searchHint, (int)(x + 1), (int)(y + 1), (int)-1);
        }
        x = this.btnNextSounds.field_230690_l_;
        y = this.btnNextSounds.field_230691_m_;
        message = "Next Sounds";
        stringW = this.field_230712_o_.func_78256_a(message) / 2;
        if (this.btnNextSounds.func_231047_b_(mouseX, mouseY)) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - stringW - 2), (int)(y - 2), (int)(x + stringW + 2), (int)(y - 13), (int)darkBG);
            MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)message, (int)x, (int)(y - 11), (int)0xFFFFFF);
        }
        x = this.btnPrevSounds.field_230690_l_;
        y = this.btnPrevSounds.field_230691_m_;
        message = "Previous Sounds";
        stringW = this.field_230712_o_.func_78256_a(message) / 2;
        if (this.btnPrevSounds.func_231047_b_(mouseX, mouseY)) {
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)(x - stringW - 2), (int)(y - 2), (int)(x + stringW + 2), (int)(y - 13), (int)darkBG);
            MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)message, (int)x, (int)(y - 11), (int)0xFFFFFF);
        }
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            int bW;
            Widget button = (Widget)this.field_230710_m_.get(i);
            if (!(button instanceof MuffledSlider)) continue;
            x = Config.getLeftButtons() ? button.field_230690_l_ - 3 : button.field_230690_l_ + 1;
            y = button.field_230691_m_;
            int n = bW = Config.getLeftButtons() ? x + button.func_230998_h_() + 5 : x + button.func_230998_h_() + 28;
            if (i % 2 != 0 || !button.field_230694_p_) continue;
            MainScreen.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)bW, (int)(y + button.func_238483_d_()), (int)brightBG);
        }
        if (Config.getShowTip()) {
            this.renderTips(matrix, Collections.singletonList(this.tip));
        }
    }

    private boolean clearRecentSounds() {
        return this.btnToggleSoundsList.func_230458_i_().equals(ITextComponent.func_244388_a((String)"Recent")) && Screen.func_231173_s_();
    }

    private void renderTips(MatrixStack ms, List<? extends ITextComponent> tips) {
        int h = this.field_230709_l_ < 334 ? 334 : this.field_230709_l_;
        GuiUtils.drawHoveringText((MatrixStack)ms, tips, (int)(this.getX() - 5), (int)(this.getY() + 223), (int)this.field_230708_k_, (int)h, (int)245, (FontRenderer)this.field_230712_o_);
    }

    private void editTitle(Anchor anchor) {
        this.editAnchorTitleBar.func_146191_b(anchor.getName());
        this.editAnchorTitleBar.field_230694_p_ = !this.editAnchorTitleBar.field_230694_p_;
        this.editAnchorRadiusBar.func_146191_b(String.valueOf(anchor.getRadius()));
        this.editAnchorRadiusBar.field_230694_p_ = !this.editAnchorRadiusBar.field_230694_p_;
        this.btnAccept.field_230694_p_ = !this.btnAccept.field_230694_p_;
        this.btnCancel.field_230694_p_ = !this.btnCancel.field_230694_p_;
        this.editAnchorRadiusBar.func_146193_g(0xFFFFFF);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double direction) {
        return this.searchBar.func_146179_b().length() > 0 ? this.listScroll(this.filteredButtons, direction * -1.0) : this.listScroll(this.field_230710_m_, direction * -1.0);
    }

    private boolean listScroll(List<Widget> buttonList, double direction) {
        int buttonH = this.minYButton;
        if (this.index <= 0 && direction < 0.0) {
            return false;
        }
        if ((this.index >= buttonList.size() - 10 || this.index >= soundsList.size() - 10) && direction > 0.0) {
            return false;
        }
        this.index += direction > 0.0 ? 10 : -10;
        for (Widget button : buttonList) {
            if (!(button instanceof MuffledSlider)) continue;
            int buttonIndex = buttonList.indexOf(button);
            boolean bl = button.field_230694_p_ = buttonIndex < this.index + 10 && buttonIndex >= this.index;
            if (button.field_230694_p_) {
                button.field_230691_m_ = buttonH;
                buttonH += button.func_238483_d_() + 2;
            }
            ((MuffledSlider)button).getBtnToggleSound().field_230691_m_ = button.field_230691_m_;
            ((MuffledSlider)button).getBtnToggleSound().field_230693_o_ = button.field_230694_p_;
            ((MuffledSlider)button).getBtnPlaySound().field_230691_m_ = button.field_230691_m_;
            ((MuffledSlider)button).getBtnPlaySound().field_230693_o_ = button.field_230694_p_;
        }
        return true;
    }

    private void updateText() {
        int buttonH = this.minYButton;
        this.filteredButtons.clear();
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof MuffledSlider)) continue;
            MuffledSlider btn = (MuffledSlider)button;
            if (btn.func_230458_i_().toString().contains(this.searchBar.func_146179_b().toLowerCase())) {
                if (!this.filteredButtons.contains(btn)) {
                    this.filteredButtons.add(btn);
                }
                btn.field_230691_m_ = buttonH;
                buttonH += btn.func_238483_d_() + 2;
                btn.field_230694_p_ = btn.field_230691_m_ < this.maxYButton;
            } else {
                btn.field_230694_p_ = false;
            }
            btn.getBtnToggleSound().field_230691_m_ = btn.field_230691_m_;
            btn.getBtnToggleSound().field_230693_o_ = btn.field_230694_p_;
            btn.getBtnPlaySound().field_230691_m_ = btn.field_230691_m_;
            btn.getBtnPlaySound().field_230693_o_ = btn.field_230694_p_;
        }
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (!this.editAnchorRadiusBar.func_146179_b().isEmpty()) {
            int Radius = Integer.parseInt(this.editAnchorRadiusBar.func_146179_b());
            this.editAnchorRadiusBar.func_146193_g(Radius > 32 || Radius < 1 ? 65535 : 0xFFFFFF);
        } else {
            this.editAnchorRadiusBar.func_146193_g(0xFFFFFF);
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.searchBar.func_231042_a_(codePoint, modifiers)) {
            this.updateText();
            return true;
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.editAnchorRadiusBar.func_200675_a(s -> s.matches("[0-9]*(?:[0-9]*)?"));
        if (this.searchBar.func_231046_a_(keyCode, scanCode, modifiers)) {
            this.updateText();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.searchBar.func_146195_b(false);
            this.editAnchorTitleBar.func_146195_b(false);
            this.editAnchorRadiusBar.func_146195_b(false);
            return true;
        }
        if (!(this.searchBar.func_230999_j_() || this.editAnchorTitleBar.func_230999_j_() || this.editAnchorRadiusBar.func_230999_j_() || !MainScreen.minecraft.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode) && keyCode != SoundMuffler.getHotkey())) {
            this.func_231175_as__();
            this.filteredButtons.clear();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.searchBar.func_230999_j_()) {
                this.searchBar.func_146180_a("");
                this.updateText();
                return true;
            }
            if (this.editAnchorTitleBar.func_230999_j_()) {
                this.editAnchorTitleBar.func_146180_a("");
                return true;
            }
            if (this.editAnchorRadiusBar.func_230449_g_()) {
                this.editAnchorRadiusBar.func_146180_a("");
                return true;
            }
        } else if (this.searchBar.func_230999_j_() && !this.searchBar.func_231044_a_(mouseX, mouseY, button)) {
            this.searchBar.func_146195_b(false);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        MuffledSlider.showSlider = false;
        MuffledSlider.tickSound = null;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    @ParametersAreNonnullByDefault
    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        this.updateText();
        super.func_231152_a_(minecraft, width, height);
    }

    public void func_231175_as__() {
        DataManager.saveData();
        super.func_231175_as__();
    }

    public static String getScreenTitle() {
        return screenTitle;
    }

    private int getX() {
        return (this.field_230708_k_ - 256) / 2;
    }

    private int getY() {
        return (this.field_230709_l_ - 202) / 2;
    }
}

