/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice.packets;

import com.supermartijn642.wormhole.packet.TargetDevicePacket;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class TargetDeviceNamePacket
extends TargetDevicePacket {
    private int index;
    private String name;

    public TargetDeviceNamePacket(Hand hand, int index, String name) {
        super(hand);
        this.index = index;
        this.name = name;
    }

    public TargetDeviceNamePacket(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        super.encode(buffer);
        buffer.writeInt(this.index);
        buffer.func_180714_a(this.name);
    }

    @Override
    protected void decodeBuffer(PacketBuffer buffer) {
        super.decodeBuffer(buffer);
        this.index = buffer.readInt();
        this.name = buffer.func_150789_c(Short.MAX_VALUE).trim();
    }

    @Override
    protected void handle(PlayerEntity player, World world, ItemStack targetDevice) {
        List<PortalTarget> targets = TargetDeviceItem.getTargets(targetDevice);
        if (this.index < 0 || this.index > targets.size() - 1) {
            return;
        }
        TargetDeviceItem.changeTargetName(targetDevice, this.index, this.name);
    }
}

