/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice;

import com.google.common.collect.Lists;
import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TargetDeviceItem
extends Item {
    private final Supplier<Integer> maxTargetCount;

    public TargetDeviceItem(String registryName, Supplier<Integer> maxTargetCount) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Wormhole.ITEM_GROUP));
        this.maxTargetCount = maxTargetCount;
        this.setRegistryName(registryName);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            ClientProxy.openTargetDeviceScreen(handIn, playerIn.func_233580_cy_(), Math.round(playerIn.field_70177_z / 90.0f) * 90);
        }
        return ActionResult.func_226249_b_((Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("wormhole.target_device.info").func_240699_a_(TextFormatting.AQUA));
        List<PortalTarget> targets = TargetDeviceItem.getTargets(stack);
        int capacity = TargetDeviceItem.getMaxTargetCount(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("wormhole.target_device.info.targets", new Object[]{targets.size(), capacity}).func_240699_a_(TextFormatting.YELLOW));
    }

    public static List<PortalTarget> getTargets(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("target")) {
            stack.func_77982_d(null);
            TargetDeviceItem.setTargets(stack, Lists.newArrayList((Object[])new PortalTarget[]{PortalTarget.read(tag.func_74775_l("target"))}));
            tag = stack.func_196082_o();
        }
        if (!tag.func_74764_b("targetCount")) {
            return new LinkedList<PortalTarget>();
        }
        int count = tag.func_74762_e("targetCount");
        ArrayList<PortalTarget> targets = new ArrayList<PortalTarget>(count);
        for (int i = 0; i < count; ++i) {
            targets.add(new PortalTarget(tag.func_74775_l("target" + i)));
        }
        return targets;
    }

    public static void setTargets(ItemStack stack, List<PortalTarget> targets) {
        if (targets == null || targets.size() == 0) {
            stack.func_77982_d(null);
        }
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a("targetCount", targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            tag.func_218657_a("target" + i, (INBT)targets.get(i).write());
        }
    }

    public static void addTarget(ItemStack stack, PortalTarget target) {
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        list.add(target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void removeTarget(ItemStack stack, int index) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list.remove(index);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void moveTarget(ItemStack stack, int index, boolean up) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        if (up ? index == 0 : index == list.size() - 1) {
            return;
        }
        PortalTarget target = list.remove(index);
        list.add(index + (up ? -1 : 1), target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void changeTargetName(ItemStack stack, int index, String name) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list.get((int)index).name = name;
        TargetDeviceItem.setTargets(stack, list);
    }

    public static int getMaxTargetCount(ItemStack stack) {
        return stack.func_77973_b() instanceof TargetDeviceItem ? ((TargetDeviceItem)stack.func_77973_b()).maxTargetCount.get() : -1;
    }
}

