/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalColorTargetPacket;
import com.supermartijn642.wormhole.portal.screen.PortalTargetColorScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PortalTargetSelectColorButton
extends AbstractButtonWidget {
    public static final ResourceLocation BUTTON_OUTLINE = new ResourceLocation("wormhole", "textures/gui/large_color_buttons.png");
    public static final ResourceLocation RANDOM_COLOR_PORTAL = new ResourceLocation("wormhole", "textures/gui/random_color_portal.png");
    private final DyeColor color;
    private final Supplier<DyeColor> targetColor;

    public PortalTargetSelectColorButton(int x, int y, PortalTargetColorScreen screen, DyeColor color) {
        super(x, y, 36, 36, () -> Wormhole.CHANNEL.sendToServer((Object)new PortalColorTargetPacket(screen.getObject(), screen.targetIndex, color)));
        this.color = color;
        this.targetColor = () -> screen.getFromPortalGroup(group -> {
            PortalTarget target = group.getTarget(screen.targetIndex);
            return target == null ? null : target.color;
        }, null);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BUTTON_OUTLINE);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)(this.targetColor.get() == this.color ? 0.6666667f : (this.isHovered() ? 0.33333334f : 0.0f)), (float)1.0f, (float)0.33333334f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.color == null ? RANDOM_COLOR_PORTAL : new ResourceLocation("wormhole", "textures/portal/portal_" + this.color.func_176762_d() + ".png"));
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)(this.x + 2), (float)(this.y + 2), (float)(this.width - 4), (float)(this.height - 4), (float)0.0f, (float)0.0f, (float)1.0f, (float)0.03125f);
    }

    protected ITextComponent getNarrationMessage() {
        return new TranslationTextComponent("wormhole.color." + (this.color == null ? "random" : this.color.func_176762_d()));
    }
}

