/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.packets;

import com.supermartijn642.wormhole.packet.PortalGroupPacket;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class PortalAddTargetPacket
extends PortalGroupPacket {
    private Hand hand;
    private int index;

    public PortalAddTargetPacket(PortalGroup group, Hand hand, int index) {
        super(group);
        this.hand = hand;
        this.index = index;
    }

    public PortalAddTargetPacket(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        super.encode(buffer);
        buffer.func_179249_a((Enum)this.hand);
        buffer.writeInt(this.index);
    }

    @Override
    protected void decode(PacketBuffer buffer) {
        super.decode(buffer);
        this.hand = (Hand)buffer.func_179257_a(Hand.class);
        this.index = buffer.readInt();
    }

    @Override
    protected void handle(PlayerEntity player, World world, PortalGroup group) {
        ItemStack stack = player.func_184586_b(this.hand);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TargetDeviceItem)) {
            return;
        }
        List<PortalTarget> targets = TargetDeviceItem.getTargets(stack);
        if (this.index >= 0 && this.index < targets.size()) {
            group.addTarget(targets.get(this.index));
        }
    }
}

