/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.wormhole.WormholeTile;
import com.supermartijn642.wormhole.portal.IPortalGroupTile;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GeneratorTile
extends WormholeTile
implements ITickableTileEntity,
IEnergyStorage {
    private static final int BLOCKS_PER_TICK = 5;
    protected int energy;
    protected final int energyCapacity;
    private final int energyRange;
    private final int energyTransferLimit;
    private final Set<BlockPos> portalBlocks = new LinkedHashSet<BlockPos>();
    private final Set<BlockPos> energyBlocks = new LinkedHashSet<BlockPos>();
    private int searchX;
    private int searchY;
    private int searchZ;

    public GeneratorTile(TileEntityType<?> tileEntityTypeIn, int energyCapacity, int energyRange, int energyTransferLimit) {
        super(tileEntityTypeIn);
        this.energyCapacity = energyCapacity;
        this.energyRange = energyRange;
        this.energyTransferLimit = energyTransferLimit;
        this.searchY = this.searchZ = -energyRange;
        this.searchX = this.searchZ;
    }

    public void func_73660_a() {
        TileEntity tile;
        for (int i = 0; i < 5; ++i) {
            BlockPos pos = this.field_174879_c.func_177982_a(this.searchX, this.searchY, this.searchZ);
            if (!pos.equals((Object)this.field_174879_c)) {
                TileEntity tile2 = this.field_145850_b.func_175625_s(pos);
                if (tile2 instanceof IPortalGroupTile && ((IPortalGroupTile)tile2).hasGroup()) {
                    this.portalBlocks.add(pos);
                    this.energyBlocks.remove(pos);
                } else if (tile2 != null && tile2.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
                    this.portalBlocks.remove(pos);
                    this.energyBlocks.add(pos);
                } else {
                    this.portalBlocks.remove(pos);
                    this.energyBlocks.remove(pos);
                }
            }
            ++this.searchX;
            if (this.searchX <= this.energyRange) continue;
            this.searchX = -this.energyRange;
            ++this.searchZ;
            if (this.searchZ <= this.energyRange) continue;
            this.searchZ = -this.energyRange;
            ++this.searchY;
            if (this.searchY <= this.energyRange) continue;
            this.searchY = -this.energyRange;
        }
        if (this.energy <= 0) {
            return;
        }
        int toTransfer = Math.min(this.energyTransferLimit, this.energy);
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (BlockPos pos : this.portalBlocks) {
            tile = this.field_145850_b.func_175625_s(pos);
            if (tile instanceof IPortalGroupTile && ((IPortalGroupTile)tile).hasGroup()) {
                PortalGroup group = ((IPortalGroupTile)tile).getGroup();
                int transferred = group.receiveEnergy(toTransfer, false);
                toTransfer -= transferred;
                this.energy -= transferred;
                if (this.energy != 0) continue;
                return;
            }
            toRemove.add(pos);
        }
        this.portalBlocks.removeAll(toRemove);
        toRemove.clear();
        for (BlockPos pos : this.energyBlocks) {
            LazyOptional optional;
            tile = this.field_145850_b.func_175625_s(pos);
            if (tile != null && (optional = tile.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
                int max = toTransfer;
                int transferred = optional.map(storage -> storage.receiveEnergy(max, false)).orElse(0);
                toTransfer -= transferred;
                this.energy -= transferred;
                if (this.energy != 0) continue;
                return;
            }
            toRemove.add(pos);
        }
        this.energyBlocks.removeAll(toRemove);
    }

    public Set<BlockPos> getChargingPortalBlocks() {
        return this.portalBlocks;
    }

    public Set<BlockPos> getChargingEnergyBlocks() {
        return this.energyBlocks;
    }

    @Override
    protected CompoundNBT writeData() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("energy", this.energy);
        data.func_74768_a("searchX", this.searchX);
        data.func_74768_a("searchY", this.searchY);
        data.func_74768_a("searchZ", this.searchZ);
        return data;
    }

    @Override
    protected void readData(CompoundNBT tag) {
        this.energy = tag.func_74764_b("energy") ? tag.func_74762_e("energy") : 0;
        this.searchX = tag.func_74764_b("searchX") ? Math.min(Math.max(tag.func_74762_e("searchX"), -this.energyRange), this.energyRange) : 0;
        this.searchY = tag.func_74764_b("searchY") ? Math.min(Math.max(tag.func_74762_e("searchY"), -this.energyRange), this.energyRange) : 0;
        this.searchZ = tag.func_74764_b("searchZ") ? Math.min(Math.max(tag.func_74762_e("searchZ"), -this.energyRange), this.energyRange) : 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return Math.min(Math.min(this.energy, this.energyTransferLimit), maxExtract);
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.energyCapacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

