/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.GeneratorTile;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CoalGeneratorTile
extends GeneratorTile
implements IItemHandlerModifiable {
    private int burnTime = 0;
    private int totalBurnTime = 0;
    private ItemStack stack = ItemStack.field_190927_a;

    public CoalGeneratorTile() {
        super(Wormhole.coal_generator_tile, WormholeConfig.coalGeneratorCapacity.get(), WormholeConfig.coalGeneratorRange.get(), WormholeConfig.coalGeneratorPower.get() * 2);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.energy < this.energyCapacity) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.energy += WormholeConfig.coalGeneratorPower.get().intValue();
                if (this.energy > this.energyCapacity) {
                    this.energy = this.energyCapacity;
                }
                if (this.burnTime == 0) {
                    this.totalBurnTime = 0;
                    this.burnItem();
                }
                this.func_70296_d();
            } else {
                this.burnItem();
            }
        }
    }

    private void burnItem() {
        int burnTime;
        int n = burnTime = this.stack.func_190926_b() ? 0 : ForgeHooks.getBurnTime((ItemStack)this.stack);
        if (burnTime > 0) {
            this.burnTime = this.totalBurnTime = burnTime;
            this.stack.func_190918_g(1);
            this.dataChanged();
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean lit = (Boolean)this.func_195044_w().func_177229_b((Property)CoalGeneratorBlock.LIT);
        if (lit != this.burnTime > 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(!lit)));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected CompoundNBT writeData() {
        CompoundNBT data = super.writeData();
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("totalBurnTime", this.totalBurnTime);
        data.func_218657_a("stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        return data;
    }

    @Override
    protected void readData(CompoundNBT tag) {
        super.readData(tag);
        this.burnTime = tag.func_74764_b("burnTime") ? tag.func_74762_e("burnTime") : 0;
        this.totalBurnTime = tag.func_74764_b("totalBurnTime") ? tag.func_74762_e("totalBurnTime") : 0;
        this.stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("stack"));
    }

    public float getProgress() {
        return this.totalBurnTime == 0 ? 0.0f : (float)this.burnTime / (float)this.totalBurnTime;
    }

    public int getSlots() {
        return 1;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            this.stack = stack.func_77946_l();
        }
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || !this.stack.func_190926_b() && (!ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)stack))) {
            return stack;
        }
        int count = Math.min(stack.func_77976_d() - this.stack.func_190916_E(), stack.func_190916_E());
        if (!simulate) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(this.stack.func_190916_E() + count);
            this.stack = newStack;
        }
        ItemStack result = stack.func_77946_l();
        result.func_190918_g(count);
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.stack.func_190926_b() ? 64 : this.stack.func_77976_d();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }
}

