/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportHelper {
    private static final int TELEPORT_COOLDOWN = 40;

    public static boolean queTeleport(Entity entity, PortalTarget target) {
        if (!TeleportHelper.canTeleport(entity, target)) {
            return false;
        }
        for (Entity passenger : entity.func_184182_bu()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            return false;
        }
        Entity lowestEntity = entity.func_184208_bv();
        if (!entity.field_70170_p.field_72995_K) {
            lowestEntity.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> TeleportHelper.teleportEntityAndPassengers(lowestEntity, null, target)));
            TeleportHelper.markEntityAndPassengers(lowestEntity);
        }
        return true;
    }

    public static boolean canTeleport(Entity entity, PortalTarget target) {
        if (entity.field_70170_p.field_72995_K || !target.getWorld(entity.func_184102_h()).isPresent()) {
            return false;
        }
        if (entity.func_184218_aH()) {
            return TeleportHelper.canTeleport(entity.func_184208_bv(), target);
        }
        for (Entity rider : entity.func_184182_bu()) {
            CompoundNBT tag = rider.getPersistentData();
            if (!tag.func_74764_b("wormhole:teleported") || (long)rider.field_70173_aa - tag.func_74763_f("wormhole:teleported") < 0L || (long)rider.field_70173_aa - tag.func_74763_f("wormhole:teleported") >= 40L) continue;
            return false;
        }
        CompoundNBT tag = entity.getPersistentData();
        return !tag.func_74764_b("wormhole:teleported") || (long)entity.field_70173_aa - tag.func_74763_f("wormhole:teleported") < 0L || (long)entity.field_70173_aa - tag.func_74763_f("wormhole:teleported") >= 40L;
    }

    private static void markEntityAndPassengers(Entity entity) {
        entity.getPersistentData().func_74772_a("wormhole:teleported", (long)entity.field_70173_aa);
        entity.func_184188_bt().forEach(TeleportHelper::markEntityAndPassengers);
    }

    private static void teleportEntityAndPassengers(Entity entity, Entity entityBeingRidden, PortalTarget target) {
        if (entity.field_70170_p.field_72995_K || !target.getWorld(entity.func_184102_h()).isPresent()) {
            return;
        }
        Optional<ServerWorld> targetWorld = target.getWorld(entity.func_184102_h()).filter(ServerWorld.class::isInstance).map(ServerWorld.class::cast);
        if (!targetWorld.isPresent()) {
            return;
        }
        List passengers = entity.func_184188_bt();
        entity.func_184226_ay();
        Entity newEntity = TeleportHelper.teleportEntity(entity, targetWorld.get(), target);
        if (entityBeingRidden != null) {
            newEntity.func_184220_m(entityBeingRidden);
            if (newEntity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)newEntity).field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(entityBeingRidden));
            }
        }
        passengers.forEach(e -> TeleportHelper.teleportEntityAndPassengers(e, newEntity, target));
    }

    private static Entity teleportEntity(Entity entity, ServerWorld targetWorld, PortalTarget target) {
        if (targetWorld == entity.field_70170_p) {
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).func_200619_a(targetWorld, (double)target.x + 0.5, (double)target.y + 0.2, (double)target.z + 0.5, target.yaw, 0.0f);
            } else {
                entity.func_70634_a((double)target.x + 0.5, (double)target.y + 0.2, (double)target.z + 0.5);
            }
            entity.func_70034_d(target.yaw);
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.field_70143_R = 0.0f;
            entity.func_230245_c_(true);
            return entity;
        }
        return entity.changeDimension(targetWorld, (ITeleporter)new WormholeTeleporter(target));
    }

    private static class WormholeTeleporter
    implements ITeleporter {
        private final PortalTarget target;

        public WormholeTeleporter(PortalTarget target) {
            this.target = target;
        }

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(this.target.getCenteredPos(), Vector3d.field_186680_a, this.target.yaw, 0.0f);
        }
    }
}

