/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.mjoellnir;

import io.github.noeppi_noeppi.libx.util.BoundingBoxUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.EventListener;
import mythicbotany.ModBlocks;
import mythicbotany.advancement.ModCriteria;
import mythicbotany.config.MythicConfig;
import mythicbotany.mjoellnir.BlockMjoellnir;
import net.minecraft.block.PortalInfo;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityMjoellnir
extends ProjectileEntity {
    private static final DataParameter<Boolean> RETURNING = EntityDataManager.func_187226_a(EntityMjoellnir.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityMjoellnir.class, (IDataSerializer)DataSerializers.field_187196_f);
    private boolean returning = false;
    private ItemStack stack = ItemStack.field_190927_a;
    private UUID thrower = null;
    private Vector3d throwPos = null;
    private int hotbarSlot = 0;
    private int lifeLeft = 40;

    public EntityMjoellnir(World world) {
        this(ModBlocks.mjoellnir.getEntityType(), world);
    }

    public EntityMjoellnir(EntityType<? extends ProjectileEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RETURNING, (Object)false);
        this.field_70180_af.func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        super.func_184206_a(key);
        if (RETURNING.equals(key)) {
            this.returning = (Boolean)this.field_70180_af.func_187225_a(RETURNING);
        } else if (STACK.equals(key)) {
            this.stack = (ItemStack)this.field_70180_af.func_187225_a(STACK);
        }
    }

    public void func_70071_h_() {
        Vector3d position;
        super.func_70071_h_();
        boolean returningTickStart = this.returning;
        if (!this.returning) {
            this.checkForCollision();
        } else if (!this.field_70170_p.field_72995_K) {
            Vector3d returnPoint = this.getReturnPoint();
            if (returnPoint != null) {
                this.applyReturnMotion(returnPoint);
            }
            this.tryReturn(returnPoint);
        }
        Vector3d motion = this.func_213322_ci();
        if (returningTickStart) {
            position = this.func_213303_ch();
            this.func_70107_b(position.field_72450_a + motion.field_72450_a, position.field_72448_b + motion.field_72448_b, position.field_72449_c + motion.field_72449_c);
        } else {
            this.func_213315_a(MoverType.SELF, motion);
        }
        --this.lifeLeft;
        if (this.lifeLeft <= 0) {
            this.startReturn();
        }
        position = this.func_213303_ch();
        this.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
    }

    private void checkForCollision() {
        Vector3d motion = this.func_213322_ci();
        Vector3d position = this.func_213303_ch();
        Vector3d rayCast = position.func_178787_e(motion);
        if (this.func_70089_S() && !((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue()) {
            EntityRayTraceResult result = ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)position, (Vector3d)rayCast, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> entity != this && !entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L() && entity != this.getThrower());
            if (result == null || result.func_216346_c() == RayTraceResult.Type.MISS) {
                result = this.field_70170_p.func_217299_a(new RayTraceContext(position, rayCast, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            }
            if (result != null && result.func_216346_c() != RayTraceResult.Type.MISS) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70227_a((RayTraceResult)result);
                } else {
                    Vector3d returnPoint = this.getReturnPoint();
                    if (returnPoint != null) {
                        this.applyReturnMotionClient(returnPoint);
                    }
                }
            }
        }
    }

    protected void func_70227_a(@Nonnull RayTraceResult hit) {
        if (!this.returning) {
            super.func_70227_a(hit);
            this.startReturn();
        }
    }

    protected void func_213868_a(@Nonnull EntityRayTraceResult hit) {
        if (hit.func_216348_a() instanceof LivingEntity) {
            this.attackEntities((LivingEntity)hit.func_216348_a());
        }
    }

    protected void func_230299_a_(@Nonnull BlockRayTraceResult hit) {
        List living = this.field_70170_p.func_175647_a(LivingEntity.class, BoundingBoxUtils.expand((Vector3d)hit.func_216347_e(), (double)2.0), entity -> !entity.func_175149_v() && entity.func_70089_S() && entity != this.getThrower());
        if (!living.isEmpty()) {
            this.attackEntities((LivingEntity)living.get(this.field_70170_p.field_73012_v.nextInt(living.size())));
        }
    }

    @Nullable
    protected PortalInfo func_241829_a(@Nonnull ServerWorld world) {
        return null;
    }

    @Nullable
    private Vector3d getReturnPoint() {
        PlayerEntity throwerEntity = this.getThrower();
        if (throwerEntity != null) {
            return throwerEntity.func_213303_ch();
        }
        if (this.throwPos != null) {
            return this.throwPos;
        }
        return null;
    }

    private void applyReturnMotion(@Nonnull Vector3d returnPoint) {
        if (!this.field_70170_p.field_72995_K) {
            Vector3d motion = this.func_213322_ci();
            Vector3d position = this.func_213303_ch();
            Vector3d returnVec = new Vector3d(returnPoint.field_72450_a - position.field_72450_a, returnPoint.field_72448_b - position.field_72448_b, returnPoint.field_72449_c - position.field_72449_c).func_72432_b().func_216372_d(0.6, 0.6, 0.6);
            double loyalty = 1.0 + 0.07 * (double)MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)this.stack), (int)0, (int)3);
            Vector3d newMotion = new Vector3d((3.0 * motion.field_72450_a + returnVec.field_72450_a) / 4.0, (3.0 * motion.field_72448_b + returnVec.field_72448_b) / 4.0, (3.0 * motion.field_72449_c + returnVec.field_72449_c) / 4.0).func_216372_d(loyalty, loyalty, loyalty);
            this.func_213317_d(newMotion);
        }
    }

    private void applyReturnMotionClient(@Nonnull Vector3d returnPoint) {
        if (this.field_70170_p.field_72995_K) {
            Vector3d motion = this.func_213322_ci();
            Vector3d position = this.func_213303_ch();
            Vector3d returnVec = new Vector3d(returnPoint.field_72450_a - position.field_72450_a, returnPoint.field_72448_b - position.field_72448_b, returnPoint.field_72449_c - position.field_72449_c).func_72432_b().func_216372_d(0.6, 0.6, 0.6);
            Vector3d newMotion = new Vector3d((3.0 * motion.field_72450_a + returnVec.field_72450_a) / 4.0, (3.0 * motion.field_72448_b + returnVec.field_72448_b) / 4.0, (3.0 * motion.field_72449_c + returnVec.field_72449_c) / 4.0);
            this.func_213317_d(newMotion);
        }
    }

    private void tryReturn(@Nullable Vector3d returnPoint) {
        if (returnPoint == null) {
            BlockMjoellnir.putInWorld(this.stack, this.field_70170_p, this.func_233580_cy_());
            this.func_70106_y();
        } else if (returnPoint.func_72436_e(this.func_213303_ch()) < 2.0) {
            PlayerEntity throwerEntity = this.getThrower();
            if (throwerEntity != null) {
                if (!BlockMjoellnir.putInInventory(throwerEntity, this.stack, this.hotbarSlot)) {
                    BlockMjoellnir.putInWorld(this.stack, this.field_70170_p, new BlockPos(returnPoint));
                }
            } else {
                BlockMjoellnir.putInWorld(this.stack, this.field_70170_p, new BlockPos(returnPoint));
            }
            this.func_70106_y();
        }
    }

    private void startReturn() {
        if (!this.returning) {
            this.setLifeLeft(0);
            this.setReturning(true);
        }
    }

    private void attackEntities(LivingEntity target) {
        List found = this.field_70170_p.func_175647_a(LivingEntity.class, BoundingBoxUtils.expand((Vector3d)target.func_213303_ch(), (double)4.0), entity -> !entity.func_175149_v() && entity.func_70089_S() && entity != this.getThrower());
        LightningBoltEntity lightning = this.attackEntity(target);
        for (LivingEntity entity2 : found) {
            if (entity2 == target) continue;
            this.areaDamage(entity2, lightning);
        }
    }

    @Nullable
    private LightningBoltEntity attackEntity(LivingEntity target) {
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity thrower;
            Vector3d vector3d;
            int knockback;
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.stack) >= 1) {
                target.func_70015_d(5);
            }
            if ((knockback = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.stack)) > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)knockback * 0.6)).func_189985_c() > 0.0) {
                target.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
            }
            int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.stack);
            float dmg = MythicConfig.mjoellnir.base_damage_ranged + 1.0f;
            if (power > 0) {
                dmg += MythicConfig.mjoellnir.enchantment_multiplier * Enchantments.field_185302_k.func_152376_a(power, target.func_70668_bt());
            }
            if ((thrower = this.getThrower()) instanceof ServerPlayerEntity) {
                ModCriteria.MJOELLNIR.trigger((ServerPlayerEntity)thrower, this.getStack(), (Entity)target);
            }
            target.func_70097_a(thrower == null ? DamageSource.field_76377_j : DamageSource.func_188403_a((Entity)this, (LivingEntity)thrower), dmg);
            LightningBoltEntity lightning = new LightningBoltEntity(EntityType.field_200728_aG, this.field_70170_p);
            lightning.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            lightning.func_233623_a_(true);
            lightning.func_204809_d(thrower instanceof ServerPlayerEntity ? (ServerPlayerEntity)thrower : null);
            this.field_70170_p.func_217376_c((Entity)lightning);
            if (this.field_70170_p instanceof ServerWorld && !ForgeEventFactory.onEntityStruckByLightning((Entity)target, (LightningBoltEntity)lightning)) {
                int fireTicks = target.func_223314_ad();
                LivingEntity oldImmune = EventListener.lightningImmuneEntity;
                EventListener.lightningImmuneEntity = target;
                target.func_241841_a((ServerWorld)this.field_70170_p, lightning);
                EventListener.lightningImmuneEntity = oldImmune;
                target.func_241209_g_(fireTicks);
            }
            return lightning;
        }
        return null;
    }

    private void areaDamage(LivingEntity target, @Nullable LightningBoltEntity lightning) {
        PlayerEntity thrower;
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.stack) >= 1) {
            target.func_70015_d(2);
        }
        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.stack);
        float dmg = MythicConfig.mjoellnir.base_damage_ranged + 1.0f;
        if (power > 0) {
            dmg += MythicConfig.mjoellnir.enchantment_multiplier * Enchantments.field_185302_k.func_152376_a(power, target.func_70668_bt());
        }
        target.func_70097_a((thrower = this.getThrower()) == null ? DamageSource.field_76377_j : DamageSource.func_188403_a((Entity)this, (LivingEntity)thrower), dmg *= MythicConfig.mjoellnir.secondary_target_multiplier);
        if (lightning != null && this.field_70170_p.field_73012_v.nextFloat() < MythicConfig.mjoellnir.secondary_lightning_chance) {
            int fireTicks = target.func_223314_ad();
            LivingEntity oldImmune = EventListener.lightningImmuneEntity;
            EventListener.lightningImmuneEntity = target;
            target.func_241841_a((ServerWorld)this.field_70170_p, lightning);
            EventListener.lightningImmuneEntity = oldImmune;
            target.func_241209_g_(fireTicks);
        }
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.field_70180_af.func_187227_b(RETURNING, (Object)returning);
        this.returning = returning;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
        this.stack = stack;
    }

    @Nullable
    public PlayerEntity getThrower() {
        if (this.field_70170_p == null || this.thrower == null) {
            return null;
        }
        return this.field_70170_p.func_217371_b(this.thrower);
    }

    @Nullable
    public UUID getThrowerId() {
        return this.thrower;
    }

    public void setThrower(@Nullable PlayerEntity thrower) {
        this.setThrowerId(thrower == null ? null : thrower.func_146103_bH().getId());
    }

    public void setThrowerId(@Nullable UUID thrower) {
        this.thrower = thrower;
    }

    @Nullable
    public Vector3d getThrowPos() {
        return this.throwPos;
    }

    public void setThrowPos(@Nullable Vector3d throwPos) {
        this.throwPos = throwPos;
    }

    public int getHotbarSlot() {
        return this.hotbarSlot;
    }

    public void setHotbarSlot(int hotbarSlot) {
        this.hotbarSlot = hotbarSlot;
    }

    public int getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(int lifeLeft) {
        this.lifeLeft = lifeLeft;
    }

    protected void func_213281_b(@Nonnull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("Stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        if (this.thrower != null) {
            nbt.func_74757_a("thrower", true);
            nbt.func_74772_a("throwerl", this.thrower.getLeastSignificantBits());
            nbt.func_74772_a("throwerm", this.thrower.getMostSignificantBits());
        } else {
            nbt.func_74757_a("thrower", false);
        }
        if (this.throwPos != null) {
            nbt.func_74757_a("throwPos", true);
            nbt.func_74780_a("throwX", this.throwPos.field_72450_a);
            nbt.func_74780_a("throwY", this.throwPos.field_72448_b);
            nbt.func_74780_a("throwZ", this.throwPos.field_72449_c);
        } else {
            nbt.func_74757_a("throwPos", false);
        }
        nbt.func_74780_a("hotbar", (double)this.hotbarSlot);
        nbt.func_74780_a("lifeTime", (double)this.lifeLeft);
        nbt.func_74757_a("returning", this.returning);
    }

    protected void func_70037_a(@Nonnull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Stack")));
        if (nbt.func_74767_n("thrower")) {
            this.setThrowerId(new UUID(nbt.func_74763_f("throwerm"), nbt.func_74763_f("throwerl")));
        } else {
            this.setThrowerId(null);
        }
        if (nbt.func_74767_n("throwPos")) {
            this.setThrowPos(new Vector3d(nbt.func_74769_h("throwX"), nbt.func_74769_h("throwY"), nbt.func_74769_h("throwZ")));
        } else {
            this.setThrowPos(null);
        }
        this.setHotbarSlot(nbt.func_74762_e("hotbar"));
        this.setLifeLeft(nbt.func_74762_e("lifeTime"));
        this.setReturning(nbt.func_74767_n("returning"));
    }
}

