/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.recipes;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class ElvenTradeProvider
extends RecipeProvider {
    public ElvenTradeProvider(DataGenerator gen) {
        super(gen);
    }

    @Nonnull
    public String func_200397_b() {
        return "MysticBotany elven trade recipes";
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> consumer) {
        consumer.accept(this.trade((ITag<Item>)ItemTags.field_206963_E, (IItemProvider)ModBlocks.dreamwoodLeaves));
    }

    private FinishedRecipe trade(IItemProvider input, IItemProvider output) {
        return this.trade(input, new ItemStack(output));
    }

    private FinishedRecipe trade(ITag<Item> input, IItemProvider output) {
        return this.trade(input, new ItemStack(output));
    }

    private FinishedRecipe trade(Ingredient input, IItemProvider output) {
        return this.trade(input, new ItemStack(output));
    }

    private FinishedRecipe trade(IItemProvider input, ItemStack output) {
        return this.trade(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), output);
    }

    private FinishedRecipe trade(ITag<Item> input, ItemStack output) {
        return this.trade(Ingredient.func_199805_a(input), output);
    }

    private FinishedRecipe trade(Ingredient input, ItemStack output) {
        return this.trade((List<Ingredient>)ImmutableList.of((Object)input), output);
    }

    private FinishedRecipe trade(List<Ingredient> inputs, ItemStack output) {
        ResourceLocation rl = Objects.requireNonNull(output.func_77973_b().getRegistryName());
        return new FinishedRecipe(new ResourceLocation(rl.func_110624_b(), "elven_trade/" + rl.func_110623_a()), inputs, (List)ImmutableList.of((Object)output));
    }

    private static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> inputs;
        private final List<ItemStack> outputs;

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
            this(id, Arrays.asList(inputs), Collections.singletonList(output));
        }

        private FinishedRecipe(ResourceLocation id, List<Ingredient> inputs, List<ItemStack> outputs) {
            this.id = id;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            JsonArray in = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                in.add(ingr.func_200304_c());
            }
            JsonArray out = new JsonArray();
            for (ItemStack s : this.outputs) {
                out.add((JsonElement)ItemNBTHelper.serializeStack((ItemStack)s));
            }
            json.add("ingredients", (JsonElement)in);
            json.add("output", (JsonElement)out);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipeTypes.ELVEN_TRADE_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

