/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import mythicbotany.MythicBotany;
import mythicbotany.config.MythicConfig;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeRemover {
    public static final ResourceLocation GAIA_PYLON = new ResourceLocation("botania", "gaia_pylon");
    public static final ResourceLocation HARD_PYLON = new ResourceLocation(MythicBotany.getInstance().modid, "modified_gaia_pylon_with_alfsteel");

    private RecipeRemover() {
    }

    public static void removeRecipes(RecipeManager rm) {
        HashSet<ResourceLocation> recipesToRemove = new HashSet<ResourceLocation>();
        if (MythicConfig.replaceGaiaRecipe) {
            recipesToRemove.add(GAIA_PYLON);
        } else {
            recipesToRemove.add(HARD_PYLON);
        }
        Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)rm, (String)"field_199522_d");
        if (recipes == null) {
            return;
        }
        Map newRecipes = (Map)recipes.entrySet().stream().map(entry -> Pair.of(entry.getKey(), RecipeRemover.withRecipesRemoved((Map)entry.getValue(), recipesToRemove))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        ObfuscationReflectionHelper.setPrivateValue(RecipeManager.class, (Object)rm, (Object)newRecipes, (String)"field_199522_d");
    }

    private static <T> ImmutableMap<ResourceLocation, T> withRecipesRemoved(Map<ResourceLocation, T> map, Set<ResourceLocation> recipesToRemove) {
        return (ImmutableMap)((Stream)map.entrySet().stream().parallel()).filter(entry -> !recipesToRemove.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

