/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class TPACommands {
    public static final HashMap<String, TPARequest> REQUESTS = new HashMap();

    public static TPARequest create(MinecraftServer server, FTBEPlayerData source, FTBEPlayerData target, boolean here) {
        String key;
        while (REQUESTS.containsKey(key = String.format("%08X", new Random().nextInt()))) {
        }
        TPARequest r = new TPARequest(key);
        r.server = server;
        r.source = source;
        r.target = target;
        r.here = here;
        r.created = System.currentTimeMillis();
        REQUESTS.put(key, r);
        return r;
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpa").requires((Predicate)FTBEConfig.TPA)).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> TPACommands.tpa(((CommandSource)context.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)context, (String)"target"), false))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpahere").requires((Predicate)FTBEConfig.TPA)).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> TPACommands.tpa(((CommandSource)context.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)context, (String)"target"), true))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpaccept").requires((Predicate)FTBEConfig.TPA)).then(Commands.func_197056_a((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpaccept(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpdeny").requires((Predicate)FTBEConfig.TPA)).then(Commands.func_197056_a((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpdeny(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
    }

    public static int tpa(ServerPlayerEntity player, ServerPlayerEntity target, boolean here) {
        FTBEPlayerData dataSource = FTBEPlayerData.get((PlayerEntity)player);
        FTBEPlayerData dataTarget = FTBEPlayerData.get((PlayerEntity)target);
        if (REQUESTS.values().stream().anyMatch(r -> r.source == dataSource && r.target == dataTarget)) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Request already sent!"), false);
            return 0;
        }
        TeleportPos.TeleportResult result = (here ? dataTarget : dataSource).tpaTeleporter.checkCooldown();
        if (!result.isSuccess()) {
            return result.runCommand(player);
        }
        TPARequest request = TPACommands.create(player.field_71133_b, dataSource, dataTarget, here);
        StringTextComponent component = new StringTextComponent("TPA request! [ ");
        component.func_230529_a_((ITextComponent)(here ? target : player).func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW));
        component.func_240702_b_(" \u27a1 ");
        component.func_230529_a_((ITextComponent)(here ? player : target).func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW));
        component.func_240702_b_(" ]");
        StringTextComponent component2 = new StringTextComponent("Click one of these: ");
        component2.func_230529_a_((ITextComponent)new StringTextComponent("Accept \u2714").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GREEN).func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + request.id)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to Accept")))));
        component2.func_240702_b_(" | ");
        component2.func_230529_a_((ITextComponent)new StringTextComponent("Deny \u274c").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + request.id)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to Deny")))));
        component2.func_240702_b_(" |");
        target.func_146105_b((ITextComponent)component, false);
        target.func_146105_b((ITextComponent)component2, false);
        player.func_146105_b((ITextComponent)new StringTextComponent("Request sent!"), false);
        return 1;
    }

    public static int tpaccept(ServerPlayerEntity player, String id) {
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Invalid request!"), false);
            return 0;
        }
        ServerPlayerEntity sourcePlayer = player.field_71133_b.func_184103_al().func_177451_a(request.source.uuid);
        if (sourcePlayer == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Player has gone offline!"), false);
            return 0;
        }
        TeleportPos.TeleportResult result = (request.here ? request.target : request.source).tpaTeleporter.teleport(request.here ? player : sourcePlayer, p -> new TeleportPos((Entity)(request.here ? sourcePlayer : player)));
        if (result.isSuccess()) {
            REQUESTS.remove(request.id);
        }
        return result.runCommand(player);
    }

    public static int tpdeny(ServerPlayerEntity player, String id) {
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Invalid request!"), false);
            return 0;
        }
        REQUESTS.remove(request.id);
        player.func_146105_b((ITextComponent)new StringTextComponent("Request denied!"), false);
        ServerPlayerEntity player2 = player.field_71133_b.func_184103_al().func_177451_a(request.target.uuid);
        if (player2 != null) {
            player2.func_146105_b((ITextComponent)new StringTextComponent("Request denied!"), false);
        }
        return 1;
    }

    public static class TPARequest {
        public final String id;
        public MinecraftServer server;
        public FTBEPlayerData source;
        public FTBEPlayerData target;
        public boolean here;
        public long created;

        public TPARequest(String s) {
            this.id = s;
        }
    }
}

