/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.base.network;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkableTileEntity;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.TransmissionNetworkHelper;
import hellfirepvp.astralsorcery.common.tile.base.TileNetwork;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class TileTransmissionBase<T extends IPrismTransmissionNode>
extends TileNetwork<T>
implements IStarlightTransmission<T>,
LinkableTileEntity {
    private final List<BlockPos> positions = new LinkedList<BlockPos>();

    protected TileTransmissionBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public boolean onSelect(PlayerEntity player) {
        if (player.func_225608_bj_()) {
            for (BlockPos linkTo : Lists.newArrayList(this.getLinkedPositions())) {
                this.tryUnlink(player, linkTo);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.link.unlink.all").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
            return false;
        }
        return true;
    }

    public abstract boolean isSingleLink();

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        ListNBT list = new ListNBT();
        for (BlockPos pos : this.positions) {
            CompoundNBT tag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(pos, tag);
            list.add((Object)tag);
        }
        compound.func_218657_a("linked", (INBT)list);
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.positions.clear();
        if (compound.func_74764_b("linked")) {
            ListNBT list = compound.func_150295_c("linked", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                this.positions.add(NBTHelper.readBlockPosFromNBT(tag));
            }
        }
    }

    @Override
    public void onBlockLinkCreate(PlayerEntity player, BlockPos other) {
        if (other.equals((Object)this.func_174877_v())) {
            return;
        }
        if (TransmissionNetworkHelper.createTransmissionLink(this, other)) {
            if (this.isSingleLink()) {
                this.positions.clear();
            }
            if (this.isSingleLink() || !this.positions.contains(other)) {
                this.positions.add(other);
                this.markForUpdate();
            }
        }
    }

    @Override
    public void onEntityLinkCreate(PlayerEntity player, LivingEntity linked) {
    }

    @Override
    @Nonnull
    public BlockPos getTrPos() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public World getTrWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean tryLinkBlock(PlayerEntity player, BlockPos other) {
        return !other.equals((Object)this.func_174877_v()) && TransmissionNetworkHelper.canCreateTransmissionLink(this, other);
    }

    @Override
    public boolean tryLinkEntity(PlayerEntity player, LivingEntity other) {
        return false;
    }

    @Override
    public boolean tryUnlink(PlayerEntity player, BlockPos other) {
        if (other.equals((Object)this.func_174877_v())) {
            return false;
        }
        if (TransmissionNetworkHelper.hasTransmissionLink(this, other)) {
            TransmissionNetworkHelper.removeTransmissionLink(this, other);
            this.positions.remove(other);
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public List<BlockPos> getLinkedPositions() {
        return this.positions;
    }
}

