/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.socket;

import hellfirepvp.astralsorcery.common.data.research.PlayerPerkData;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.node.socket.GemSocketItem;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public interface GemSocketPerk {
    public static final String SOCKET_DATA_KEY = "socketedItem";

    default public boolean hasItem(PlayerEntity player, LogicalSide side) {
        return this.hasItem(player, side, null);
    }

    default public boolean hasItem(PlayerEntity player, LogicalSide side, @Nullable CompoundNBT data) {
        return !this.getContainedItem(player, side, data).func_190926_b();
    }

    default public ItemStack getContainedItem(PlayerEntity player, LogicalSide side) {
        return this.getContainedItem(player, side, null);
    }

    default public ItemStack getContainedItem(PlayerEntity player, LogicalSide side, @Nullable CompoundNBT dataOvr) {
        CompoundNBT data;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        CompoundNBT compoundNBT = data = dataOvr != null ? dataOvr : ((AbstractPerk)((Object)this)).getPerkData(player, side);
        if (data == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = NBTHelper.getStack(data, SOCKET_DATA_KEY);
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    default public boolean setContainedItem(PlayerEntity player, LogicalSide side, ItemStack stack) {
        return this.setContainedItem(player, side, null, stack);
    }

    default public <T extends AbstractPerk> boolean setContainedItem(PlayerEntity player, LogicalSide side, @Nullable CompoundNBT dataOvr, ItemStack stack) {
        CompoundNBT data;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        AbstractPerk thisPerk = (AbstractPerk)((Object)this);
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (!prog.getPerkData().hasPerkEffect(thisPerk)) {
            return false;
        }
        boolean updateData = dataOvr == null;
        CompoundNBT compoundNBT = data = dataOvr != null ? dataOvr : ((AbstractPerk)((Object)this)).getPerkData(player, side);
        if (data == null) {
            return false;
        }
        CompoundNBT prev = data.func_74737_b();
        if (stack.func_190926_b()) {
            ItemStack existing = NBTHelper.getStack(data, SOCKET_DATA_KEY);
            if (!existing.func_190926_b() && existing.func_77973_b() instanceof GemSocketItem) {
                ((GemSocketItem)existing.func_77973_b()).onExtract(existing, thisPerk, player, prog);
            }
            data.func_82580_o(SOCKET_DATA_KEY);
        } else {
            if (stack.func_77973_b() instanceof GemSocketItem) {
                ((GemSocketItem)stack.func_77973_b()).onInsert(stack, thisPerk, player, prog);
            }
            NBTHelper.setStack(data, SOCKET_DATA_KEY, stack);
        }
        if (updateData) {
            ResearchManager.setPerkData(player, thisPerk, prev, data);
        }
        return true;
    }

    default public void dropItemToPlayer(PlayerEntity player) {
        this.dropItemToPlayer(player, null);
    }

    default public void dropItemToPlayer(PlayerEntity player, @Nullable CompoundNBT data) {
        boolean updateData;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        boolean bl = updateData = data == null;
        if (updateData) {
            data = ((AbstractPerk)((Object)this)).getPerkData(player, LogicalSide.SERVER);
        }
        if (data == null) {
            return;
        }
        CompoundNBT prev = data.func_74737_b();
        ItemStack contained = this.getContainedItem(player, LogicalSide.SERVER, data);
        if (!contained.func_190926_b() && !player.func_191521_c(contained)) {
            ItemUtils.dropItem(player.func_130014_f_(), player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), contained);
        }
        this.setContainedItem(player, LogicalSide.SERVER, data, ItemStack.field_190927_a);
        if (updateData) {
            ResearchManager.setPerkData(player, (AbstractPerk)((Object)this), prev, data);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public <T extends AbstractPerk> void addTooltipInfo(Collection<IFormattableTextComponent> tooltip) {
        if (!(this instanceof AbstractPerk)) {
            return;
        }
        AbstractPerk thisPerk = (AbstractPerk)((Object)this);
        PlayerProgress prog = ResearchHelper.getClientProgress();
        if (!prog.isValid()) {
            return;
        }
        PlayerPerkData perkData = prog.getPerkData();
        ItemStack contained = this.getContainedItem((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT);
        if (contained.func_190926_b()) {
            tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.empty").func_240699_a_(TextFormatting.GRAY));
            if (perkData.hasPerkEffect(thisPerk)) {
                boolean has;
                tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.content.empty").func_240699_a_(TextFormatting.GRAY));
                boolean bl = has = !ItemUtils.findItemsIndexedInPlayerInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack -> {
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof GemSocketItem)) {
                        return false;
                    }
                    GemSocketItem item = (GemSocketItem)stack.func_77973_b();
                    return item.canBeInserted((ItemStack)stack, thisPerk, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, ResearchHelper.getClientProgress(), LogicalSide.CLIENT);
                }).isEmpty();
                if (!has) {
                    tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.content.empty.none").func_240699_a_(TextFormatting.RED));
                }
            }
        } else {
            if (contained.func_77973_b() instanceof GemSocketItem) {
                GemSocketItem item = (GemSocketItem)contained.func_77973_b();
                ArrayList<IFormattableTextComponent> additionalToolTip = new ArrayList<IFormattableTextComponent>();
                item.addTooltip(contained, thisPerk, additionalToolTip);
                if (!additionalToolTip.isEmpty()) {
                    tooltip.addAll(additionalToolTip);
                    tooltip.add((IFormattableTextComponent)new StringTextComponent(""));
                }
            }
            tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.content.item", new Object[]{contained.func_200301_q()}).func_240699_a_(TextFormatting.GRAY));
            if (perkData.hasPerkEffect(thisPerk)) {
                tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.remove").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }
}

