/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.perk.source.ModifierManager;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSourceProvider;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncModifierSource
extends ASPacket<PktSyncModifierSource> {
    private ModifierSource source = null;
    private PerkEffectHelper.Action action = null;

    public PktSyncModifierSource() {
    }

    public PktSyncModifierSource(ModifierSource perk, PerkEffectHelper.Action action) {
        this.source = perk;
        this.action = action;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncModifierSource> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeOptional(buffer, packet.action, ByteBufUtils::writeEnumValue);
            ResourceLocation providerName = packet.source.getProviderName();
            ByteBufUtils.writeResourceLocation(buffer, providerName);
            ModifierSourceProvider<?> provider = ModifierManager.getProvider(providerName);
            if (provider == null) {
                throw new IllegalArgumentException("Unknown provider: " + providerName);
            }
            provider.serialize(packet.source, (PacketBuffer)buffer);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncModifierSource> decoder() {
        return buffer -> {
            PktSyncModifierSource pkt = new PktSyncModifierSource();
            pkt.action = ByteBufUtils.readOptional(buffer, byteBuf -> ByteBufUtils.readEnumValue(byteBuf, PerkEffectHelper.Action.class));
            ResourceLocation providerName = ByteBufUtils.readResourceLocation(buffer);
            ModifierSourceProvider<?> provider = ModifierManager.getProvider(providerName);
            if (provider == null) {
                throw new IllegalArgumentException("Unknown provider: " + providerName);
            }
            pkt.source = provider.deserialize((PacketBuffer)buffer);
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncModifierSource> handler() {
        return new ASPacket.Handler<PktSyncModifierSource>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncModifierSource packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player == null) {
                        return;
                    }
                    PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.CLIENT, packet.source, packet.action);
                });
            }

            @Override
            public void handle(PktSyncModifierSource packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

