/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingOverlayUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.entry.WandsConfig;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.ItemBlockStorage;
import hellfirepvp.astralsorcery.common.item.base.client.ItemHeldRender;
import hellfirepvp.astralsorcery.common.item.base.client.ItemOverlayRender;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.client.util.BufferDecoratorBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.LogicalSide;

public class ItemExchangeWand
extends Item
implements ItemBlockStorage,
ItemOverlayRender,
ItemHeldRender,
AlignmentChargeConsumer {
    private static final float COST_PER_EXCHANGE = 5.0f;

    public ItemExchangeWand() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)ItemExchangeWand.getSizeMode(stack).getDisplay().func_240699_a_(TextFormatting.GOLD));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return 3;
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        return Sets.newHashSet((Object[])new ToolType[]{ToolType.PICKAXE, ToolType.AXE, ToolType.SHOVEL});
    }

    public boolean func_150897_b(BlockState blockIn) {
        return true;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return true;
    }

    @Override
    public float getAlignmentChargeCost(PlayerEntity player, ItemStack stack) {
        BlockRayTraceResult hitResult = MiscUtils.rayTraceLookBlock(player, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE);
        if (hitResult == null) {
            return 0.0f;
        }
        return (float)this.getPlaceStates(player, player.func_130014_f_(), hitResult.func_216350_a(), stack).size() * 5.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderInHand(ItemStack stack, MatrixStack renderStack, float pTicks) {
        BlockRayTraceResult hitResult = MiscUtils.rayTraceLookBlock((PlayerEntity)Minecraft.func_71410_x().field_71439_g, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE);
        if (hitResult == null) {
            return true;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos at = hitResult.func_216350_a();
        Map<BlockPos, BlockState> placeStates = this.getPlaceStates((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (World)world, at, stack);
        if (placeStates.isEmpty()) {
            return true;
        }
        RenderSystem.enableTexture();
        BlockAtlasTexture.getInstance().bindTexture();
        int[] fullBright = new int[]{15, 15};
        BufferDecoratorBuilder decorator = BufferDecoratorBuilder.withLightmap((skyLight, blockLight) -> fullBright);
        Vector3 offset = RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks);
        RenderSystem.enableBlend();
        Blending.ADDITIVEDARK.apply();
        RenderSystem.disableDepthTest();
        RenderSystem.disableAlphaTest();
        RenderingUtils.draw(7, DefaultVertexFormats.field_176600_a, buf -> placeStates.forEach((pos, state) -> {
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)pos.func_177958_n() - offset.getX() + (double)0.1f, (double)pos.func_177956_o() - offset.getY() + (double)0.1f, (double)pos.func_177952_p() - offset.getZ() + (double)0.1f);
            renderStack.func_227862_a_(0.8f, 0.8f, 0.8f);
            RenderingUtils.renderSimpleBlockModel(state, renderStack, (IVertexBuilder)decorator.decorate(buf), pos, null, false);
            renderStack.func_227865_b_();
        }));
        RenderSystem.enableAlphaTest();
        RenderSystem.enableDepthTest();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderOverlay(MatrixStack renderStack, ItemStack stack, float pTicks) {
        List<Tuple<ItemStack, Integer>> foundStacks = ItemBlockStorage.getInventoryMatchingItemStacks((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack);
        RenderingOverlayUtils.renderDefaultItemDisplay(renderStack, foundStacks);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        if (world.func_201670_d() || !(player instanceof ServerPlayerEntity) || stack.func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_()) {
            ItemBlockStorage.storeBlockState(stack, world, pos);
            return ActionResultType.SUCCESS;
        }
        Map<BlockPos, BlockState> placeStates = this.getPlaceStates(player, world, pos, stack);
        Map<BlockState, Tuple> availableStacks = MapStream.of(ItemBlockStorage.getInventoryMatching(player, stack)).filter((Predicate<Tuple<BlockState, Tuple<ItemStack, Integer>>>)((Predicate<Tuple>)tpl -> placeStates.containsValue(tpl.func_76341_a()))).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
        for (BlockPos placePos : placeStates.keySet()) {
            BlockState stateToPlace = placeStates.get(placePos);
            Tuple availableStack = availableStacks.get(stateToPlace);
            if (availableStack == null) continue;
            ItemStack extractable = ItemUtils.copyStackWithSize((ItemStack)availableStack.func_76341_a(), 1);
            boolean canExtract = player.func_184812_l_();
            if (!canExtract && ItemUtils.consumeFromPlayerInventory(player, stack, extractable, true)) {
                canExtract = true;
            }
            if (!canExtract) continue;
            BlockState prevState = world.func_180495_p(placePos);
            if (!player.func_184812_l_() && !ItemUtils.consumeFromPlayerInventory(player, stack, extractable, true) || !AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, 5.0f, false) || !((ServerPlayerEntity)player).field_71134_c.func_180237_b(placePos) || !MiscUtils.canPlayerPlaceBlockPos(player, stateToPlace, placePos, Direction.UP) || !player.func_184812_l_() && !ItemUtils.consumeFromPlayerInventory(player, stack, extractable, false) || !world.func_175656_a(placePos, stateToPlace)) continue;
            PktPlayEffect ev = new PktPlayEffect(PktPlayEffect.Type.BLOCK_EFFECT).addData(buf -> {
                ByteBufUtils.writePos(buf, placePos);
                ByteBufUtils.writeBlockState(buf, prevState);
            });
            PacketChannel.CHANNEL.sendToAllAround(ev, PacketChannel.pointFromPos(world, (Vector3i)placePos, 32.0));
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            SizeMode nextMode = ItemExchangeWand.getSizeMode(held).next();
            ItemExchangeWand.setSizeMode(held, nextMode);
            playerIn.func_146105_b((ITextComponent)nextMode.getDisplay(), true);
        }
        return ActionResult.func_226248_a_((Object)held);
    }

    @Nonnull
    private Map<BlockPos, BlockState> getPlaceStates(PlayerEntity placer, World world, BlockPos origin, ItemStack refStack) {
        Map<BlockState, Tuple<ItemStack, Integer>> tplStates = ItemBlockStorage.getInventoryMatching(placer, refStack);
        BlockState atState = world.func_180495_p(origin);
        SizeMode mode = ItemExchangeWand.getSizeMode(refStack);
        HashMap placeables = Maps.newHashMap();
        BlockState match = BlockUtils.getMatchingState(tplStates.keySet(), atState);
        if (match != null && tplStates.size() <= 1) {
            return placeables;
        }
        float hardness = atState.func_185887_b((IBlockReader)world, origin);
        int cfgHardness = (Integer)WandsConfig.CONFIG.exchangeWandMaxHardness.get();
        if (hardness == -1.0f || cfgHardness != -1 && hardness > (float)cfgHardness) {
            return placeables;
        }
        int totalItems = 0;
        if (placer.func_184812_l_()) {
            totalItems = Integer.MAX_VALUE;
        } else {
            for (Tuple<ItemStack, Integer> amountTpl : tplStates.values()) {
                totalItems += (Integer)amountTpl.func_76340_b() == -1 ? 500000 : (Integer)amountTpl.func_76340_b();
            }
        }
        List<BlockPos> foundPositions = BlockDiscoverer.discoverBlocksWithSameStateAround(world, origin, true, mode.getSearchRadius(), totalItems, false);
        if (foundPositions.isEmpty()) {
            return placeables;
        }
        HashMap placeAmounts = Maps.newHashMap();
        for (BlockState state : tplStates.keySet()) {
            placeAmounts.put(state, placer.func_184812_l_() ? Integer.valueOf(Integer.MAX_VALUE) : (Integer)tplStates.get(state).func_76340_b());
        }
        ArrayList placeableStates = Lists.newArrayList(placeAmounts.keySet());
        Random rand = ItemBlockStorage.getPreviewRandomFromWorld(world);
        for (BlockPos pos : foundPositions) {
            Collections.shuffle(placeableStates, rand);
            BlockState toPlace = (BlockState)Iterables.getFirst((Iterable)placeableStates, null);
            if (toPlace == null) continue;
            if (!placer.func_184812_l_()) {
                int count = (Integer)placeAmounts.get(toPlace);
                if (--count <= 0) {
                    placeAmounts.remove(toPlace);
                    placeableStates.remove(toPlace);
                } else {
                    placeAmounts.put(toPlace, count);
                }
            }
            placeables.put(pos, toPlace);
        }
        return placeables;
    }

    public static void setSizeMode(@Nonnull ItemStack stack, @Nonnull SizeMode mode) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemExchangeWand)) {
            return;
        }
        CompoundNBT nbt = NBTHelper.getPersistentData(stack);
        nbt.func_74768_a("sizeMode", mode.ordinal());
    }

    @Nonnull
    public static SizeMode getSizeMode(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemExchangeWand)) {
            return SizeMode.RANGE_2;
        }
        CompoundNBT nbt = NBTHelper.getPersistentData(stack);
        return MiscUtils.getEnumEntry(SizeMode.class, nbt.func_74762_e("sizeMode"));
    }

    public static enum SizeMode {
        RANGE_2(2),
        RANGE_3(3),
        RANGE_4(4),
        RANGE_5(5);

        private final int searchRadius;

        private SizeMode(int searchRadius) {
            this.searchRadius = searchRadius;
        }

        public int getSearchRadius() {
            return this.searchRadius;
        }

        public IFormattableTextComponent getName() {
            return new TranslationTextComponent("astralsorcery.misc.exchange.size." + this.searchRadius);
        }

        public IFormattableTextComponent getDisplay() {
            return new TranslationTextComponent("astralsorcery.misc.exchange.size", new Object[]{this.getName()});
        }

        @Nonnull
        private SizeMode next() {
            int next = (this.ordinal() + 1) % SizeMode.values().length;
            return MiscUtils.getEnumEntry(SizeMode.class, next);
        }
    }
}

