/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.lens;

import hellfirepvp.astralsorcery.common.util.PartialEffectExecutor;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class LensColorType {
    private static final Map<ResourceLocation, LensColorType> BY_NAME = new HashMap<ResourceLocation, LensColorType>();
    private final Supplier<ItemStack> itemSupplier;
    private final ResourceLocation name;
    private final TargetType type;
    private final Color color;
    private final float flowReduction;
    private final boolean ignoresBlockCollision;

    public LensColorType(ResourceLocation name, TargetType type, Supplier<ItemStack> itemSupplier, Color color, float flowReduction, boolean ignoresBlockCollision) {
        this.name = name;
        this.type = type;
        this.color = color;
        this.flowReduction = flowReduction;
        this.ignoresBlockCollision = ignoresBlockCollision;
        this.itemSupplier = itemSupplier;
        BY_NAME.put(name, this);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public TargetType getType() {
        return this.type;
    }

    public float getFlowMultiplier() {
        return this.flowReduction;
    }

    public boolean doesIgnoreBlockCollision() {
        return this.ignoresBlockCollision;
    }

    public Color getColor() {
        return this.color;
    }

    public ItemStack getStack() {
        return this.itemSupplier.get();
    }

    @Nullable
    public static LensColorType byName(ResourceLocation name) {
        return BY_NAME.get(name);
    }

    public abstract void entityInBeam(World var1, Vector3 var2, Vector3 var3, Entity var4, PartialEffectExecutor var5);

    public abstract void blockInBeam(World var1, BlockPos var2, BlockState var3, PartialEffectExecutor var4);

    public static enum TargetType {
        ANY,
        ENTITY,
        BLOCK,
        NONE;


        public boolean doEntityInteraction() {
            return this == ANY || this == ENTITY;
        }

        public boolean doBlockInteraction() {
            return this == ANY || this == BLOCK;
        }
    }
}

