/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.crt;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInteraction;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.InteractionResult;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.ResultDropItem;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.ResultSpawnEntity;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.astralsorcery,LiquidInteractionManager")
public class LiquidInteractionManager
implements IRecipeManager {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IFluidStack reactant1, float chanceConsumeReactant1, IFluidStack reactant2, float chanceConsumeReactant2, int weight) {
        name = this.fixRecipeName(name);
        ResourceLocation recipeId = new ResourceLocation(name);
        LiquidInteraction recipe = new LiquidInteraction(recipeId, reactant1.getInternal(), chanceConsumeReactant1, reactant2.getInternal(), chanceConsumeReactant2, weight, ResultDropItem.dropItem(output.getInternal()));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, "Drop Item"));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, MCEntityType output, IFluidStack reactant1, float chanceConsumeReactant1, IFluidStack reactant2, float chanceConsumeReactant2, int weight) {
        name = this.fixRecipeName(name);
        ResourceLocation recipeId = new ResourceLocation(name);
        LiquidInteraction recipe = new LiquidInteraction(recipeId, reactant1.getInternal(), chanceConsumeReactant1, reactant2.getInternal(), chanceConsumeReactant2, weight, ResultSpawnEntity.spawnEntity(output.getInternal()));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, "Spawn Entity"));
    }

    public void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, iRecipe -> {
            LiquidInteraction recipe = (LiquidInteraction)iRecipe;
            InteractionResult result = recipe.getResult();
            if (result instanceof ResultDropItem) {
                ResultDropItem resultDropItem = (ResultDropItem)result;
                return output.matches((IItemStack)new MCItemStackMutable(resultDropItem.getOutput()));
            }
            return false;
        }).describeDefaultRemoval((CommandStringDisplayable)output));
    }

    @ZenCodeType.Method
    public void removeRecipe(MCEntityType entityType) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, iRecipe -> {
            LiquidInteraction recipe = (LiquidInteraction)iRecipe;
            InteractionResult result = recipe.getResult();
            if (result instanceof ResultSpawnEntity) {
                ResultSpawnEntity resultSpawnEntity = (ResultSpawnEntity)result;
                return entityType.getInternal() == resultSpawnEntity.getEntityType();
            }
            return false;
        }).describeDefaultRemoval((CommandStringDisplayable)entityType));
    }

    public IRecipeType<LiquidInteraction> getRecipeType() {
        return RecipeTypesAS.TYPE_LIQUID_INTERACTION.getType();
    }
}

