/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravingEffect;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IConstellation
extends IForgeRegistryEntry<IConstellation>,
Comparable<IConstellation> {
    public static final int STAR_GRID_INDEX = 31;
    public static final int STAR_GRID_WIDTH_HEIGHT = 32;

    public StarLocation addStar(int var1, int var2);

    public StarConnection addConnection(StarLocation var1, StarLocation var2);

    public int getSortingId();

    public List<StarLocation> getStars();

    public List<StarConnection> getStarConnections();

    public String getSimpleName();

    public String getTranslationKey();

    default public IFormattableTextComponent getConstellationName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    default public IFormattableTextComponent getConstellationTypeDescription() {
        String type = "unknown";
        if (this instanceof IMajorConstellation) {
            type = "major";
        } else if (this instanceof IWeakConstellation) {
            type = "weak";
        } else if (this instanceof IMinorConstellation) {
            type = "minor";
        }
        return new TranslationTextComponent(String.format("astralsorcery.journal.constellation.type.%s", type));
    }

    default public IFormattableTextComponent getConstellationTag() {
        return new TranslationTextComponent(this.getTranslationKey() + ".tag");
    }

    default public IFormattableTextComponent getConstellationDescription() {
        return new TranslationTextComponent(this.getTranslationKey() + ".description");
    }

    default public IFormattableTextComponent getConstellationEnchantmentDescription() {
        return new TranslationTextComponent(this.getTranslationKey() + ".enchantments");
    }

    public static String getDefaultSaveKey() {
        return "constellationName";
    }

    public List<Ingredient> getConstellationSignatureItems();

    @Nullable
    default public EngravingEffect getEngravingEffect() {
        return (EngravingEffect)RegistriesAS.REGISTRY_ENGRAVING_EFFECT.getValue(this.getRegistryName());
    }

    default public IConstellation addSignatureItem(ItemStack item) {
        return this.addSignatureItem(() -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item}));
    }

    default public IConstellation addSignatureItem(IItemProvider item) {
        return this.addSignatureItem(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    default public IConstellation addSignatureItem(ITag<Item> tag) {
        return this.addSignatureItem(() -> Ingredient.func_199805_a((ITag)tag));
    }

    public IConstellation addSignatureItem(Supplier<Ingredient> var1);

    public Color getConstellationColor();

    default public Color getTierRenderColor() {
        if (this instanceof IMinorConstellation) {
            return ColorsAS.CONSTELLATION_TYPE_MINOR;
        }
        if (this instanceof IMajorConstellation) {
            return ColorsAS.CONSTELLATION_TYPE_MAJOR;
        }
        return ColorsAS.CONSTELLATION_TYPE_WEAK;
    }

    public boolean canDiscover(PlayerEntity var1, PlayerProgress var2);

    default public void writeToNBT(CompoundNBT compound) {
        this.writeToNBT(compound, IConstellation.getDefaultSaveKey());
    }

    default public void writeToNBT(CompoundNBT compound, String key) {
        compound.func_74778_a(key, this.getRegistryName().toString());
    }

    @Nullable
    public static IConstellation readFromNBT(CompoundNBT compound) {
        return IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey());
    }

    @Nullable
    public static IConstellation readFromNBT(CompoundNBT compound, String key) {
        return ConstellationRegistry.getConstellation(new ResourceLocation(compound.func_74779_i(key)));
    }

    default public Class<IConstellation> getRegistryType() {
        return IConstellation.class;
    }
}

