/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.entity;

import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXPositionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingSprite;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.resource.query.SpriteQuery;
import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PatreonFlare
extends PatreonPartialEntity {
    public Object clientSprite = null;

    public PatreonFlare(UUID effectUUID, UUID ownerUUID) {
        super(effectUUID, ownerUUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
        Object sprite;
        super.tickClient();
        if (this.clientSprite != null && ((EntityComplexFX)(sprite = (FXFacingSprite)this.clientSprite)).isRemoved() && ((Boolean)RenderingConfig.CONFIG.patreonEffects.get()).booleanValue()) {
            this.clientSprite = null;
        }
        if (this.clientSprite == null && (sprite = this.getSpriteQuery()) != null) {
            this.clientSprite = ((EntityComplexFX)((EntityVisualFX)((FXFacingSprite)EffectHelper.of(EffectTemplatesAS.FACING_SPRITE).spawn(this.pos)).setSprite(((SpriteQuery)sprite).resolveSprite()).setScaleMultiplier(0.35f)).position(new VFXPositionController<EntityVisualFX>(){

                @Override
                @Nonnull
                public Vector3 updatePosition(@Nonnull EntityVisualFX fx, @Nonnull Vector3 position, @Nonnull Vector3 motionToBeMoved) {
                    return PatreonFlare.this.pos.clone();
                }
            })).refresh(fx -> !this.removed && (Boolean)RenderingConfig.CONFIG.patreonEffects.get() != false);
        }
    }

    @Nullable
    protected SpriteQuery getSpriteQuery() {
        FlareColor color = this.getFlareColor();
        if (color != null) {
            return color.getSpriteQuery();
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickEffects(World world) {
        super.tickEffects(world);
        if (!((Boolean)RenderingConfig.CONFIG.patreonEffects.get()).booleanValue() || rand.nextBoolean()) {
            return;
        }
        Color c = this.getColor();
        if (c == null) {
            return;
        }
        int age = 30 + rand.nextInt(15);
        float scale = 0.1f + rand.nextFloat() * 0.1f;
        Vector3 at = new Vector3(this.pos);
        at.add((double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1));
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(scale)).color(VFXColorFunction.constant(c))).setMaxAge(age);
        if (rand.nextBoolean()) {
            ((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(scale * 0.3f)).setMaxAge(age - 10);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected Color getColor() {
        FlareColor col = this.getFlareColor();
        if (col == null) {
            return null;
        }
        return rand.nextInt(3) == 0 ? col.color2 : col.color1;
    }

    @Nullable
    private FlareColor getFlareColor() {
        PatreonEffect effect = this.getEffect();
        if (effect != null) {
            return effect.getFlareColor();
        }
        return null;
    }
}

