/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import com.hrznstudio.emojiful.Emojiful;
import com.hrznstudio.emojiful.api.Emoji;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class EmojiFromEmojipedia
extends Emoji {
    public SimpleTexture img;
    public ResourceLocation resourceLocation = loading_texture;

    @Override
    public void checkLoad() {
        if (this.img != null) {
            return;
        }
        this.img = new DownloadImageData(new File("emojiful/cache/" + this.name + "-" + this.version), "https://cdn.emojidex.com/emoji/px32/" + this.location + ".png", loading_texture);
        this.resourceLocation = new ResourceLocation("emojiful", "texures/emoji/" + this.location.toLowerCase() + "_" + this.version);
        Minecraft.func_71410_x().func_110434_K().func_229263_a_(this.resourceLocation, (Texture)this.img);
    }

    @Override
    public ResourceLocation getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.func_147631_c();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public class DownloadImageData
    extends SimpleTexture {
        private final File cacheFile;
        private final String imageUrl;
        private NativeImage nativeImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public DownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.nativeImage != null) {
                if (this.field_110568_b != null) {
                    this.func_147631_c();
                }
                TextureUtil.func_225680_a_((int)super.func_110552_b(), (int)this.nativeImage.func_195702_a(), (int)this.nativeImage.func_195714_b());
                this.nativeImage.func_195697_a(0, 0, 0, true);
                this.textureUploaded = true;
            }
        }

        private void setImage(NativeImage nativeImageIn) {
            Minecraft.func_71410_x().execute(() -> {
                this.textureUploaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
                } else {
                    this.upload(nativeImageIn);
                }
            });
        }

        private void upload(NativeImage imageIn) {
            TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
            imageIn.func_195697_a(0, 0, 0, true);
        }

        @Nullable
        private NativeImage loadTexture(InputStream inputStreamIn) {
            NativeImage nativeimage = null;
            try {
                nativeimage = NativeImage.func_195713_a((InputStream)inputStreamIn);
            }
            catch (IOException ioexception) {
                Emojiful.LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
            }
            return nativeimage;
        }

        public void func_195413_a(IResourceManager resourceManager) throws IOException {
            if (this.imageThread == null) {
                if (this.cacheFile != null && this.cacheFile.isFile()) {
                    try {
                        FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                        this.setImage(this.loadTexture(fileinputstream));
                    }
                    catch (IOException ioexception) {
                        this.loadTextureFromServer();
                    }
                } else {
                    this.loadTextureFromServer();
                }
            }
        }

        protected void loadTextureFromServer() {
            this.imageThread = new Thread("Emojiful Texture Downloader #" + Emoji.threadDownloadCounter.incrementAndGet()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(DownloadImageData.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputStream;
                            int contentLength = httpurlconnection.getContentLength();
                            if (DownloadImageData.this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)DownloadImageData.this.cacheFile);
                                inputStream = new FileInputStream(DownloadImageData.this.cacheFile);
                            } else {
                                inputStream = httpurlconnection.getInputStream();
                            }
                            DownloadImageData.this.setImage(DownloadImageData.this.loadTexture(inputStream));
                        } else {
                            EmojiFromEmojipedia.this.resourceLocation = Emoji.noSignal_texture;
                            EmojiFromEmojipedia.this.deleteOldTexture = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EmojiFromEmojipedia.this.resourceLocation = Emoji.error_texture;
                        EmojiFromEmojipedia.this.deleteOldTexture = true;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

