/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.world;

import com.direwolf20.buildinggadgets.common.world.MockDelegationWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;

public class DelegationWorld
extends World {
    private static final Scoreboard SCOREBOARD = new Scoreboard();
    private World delegate;
    private Map<BlockPos, MockDelegationWorld.BlockInfo> posToBlock;

    public DelegationWorld() {
        super((ISpawnWorldInfo)Minecraft.func_71410_x().field_71441_e.func_72912_H(), Minecraft.func_71410_x().field_71441_e.func_234923_W_(), Minecraft.func_71410_x().field_71441_e.func_230315_m_(), Minecraft.func_71410_x().field_71441_e.func_234924_Y_(), true, true, 0L);
        this.delegate = Minecraft.func_71410_x().field_71441_e;
    }

    public Set<Map.Entry<BlockPos, MockDelegationWorld.BlockInfo>> entrySet() {
        return Collections.unmodifiableSet(this.posToBlock.entrySet());
    }

    @Nullable
    public MockDelegationWorld.BlockInfo getOverriddenBlock(BlockPos pos) {
        return this.posToBlock.get(pos);
    }

    @Nullable
    public BlockState getOverriddenState(BlockPos pos) {
        MockDelegationWorld.BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getState() : null;
    }

    @Nullable
    public TileEntity getOverriddenTile(BlockPos pos) {
        MockDelegationWorld.BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getEntity((IWorld)this) : null;
    }

    public void clear() {
        this.posToBlock.clear();
    }

    public boolean removeOverride(BlockPos pos) {
        MockDelegationWorld.BlockInfo info = this.posToBlock.remove(pos);
        if (info != null) {
            info.onRemove();
            return true;
        }
        return false;
    }

    protected MockDelegationWorld.BlockInfo createInfo(BlockPos pos, BlockState state) {
        return new MockDelegationWorld.BlockInfo(pos, state);
    }

    public boolean func_217377_a(BlockPos blockPos, boolean b) {
        return this.removeOverride(blockPos);
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.func_180495_p(p_217375_1_));
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return null;
        }
        MockDelegationWorld.BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            return info.getEntity((IWorld)this);
        }
        return this.delegate.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        BlockState state = this.getOverriddenState(pos);
        return state != null ? state : Blocks.field_150350_a.func_176223_P();
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public boolean func_241211_a_(BlockPos p_241211_1_, BlockState p_241211_2_, int p_241211_3_, int p_241211_4_) {
        return false;
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        MockDelegationWorld.BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            info.setState(newState);
        } else {
            this.posToBlock.put(pos, this.createInfo(pos, newState));
        }
        return true;
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        return !this.func_180495_p(pos).isAir((IBlockReader)this, pos) && this.func_217377_a(pos, true);
    }

    public boolean func_241212_a_(BlockPos pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        return false;
    }

    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return null;
    }

    @Nullable
    public MapData func_217406_a(String mapName) {
        return null;
    }

    public void func_217399_a(MapData mapDataIn) {
    }

    public int func_217395_y() {
        return 0;
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
    }

    public Scoreboard func_96441_U() {
        return SCOREBOARD;
    }

    public RecipeManager func_199532_z() {
        return null;
    }

    public ITagCollectionSupplier func_205772_D() {
        return null;
    }

    public ITickList<Block> func_205220_G_() {
        return this.delegate.func_205220_G_();
    }

    public ITickList<Fluid> func_205219_F_() {
        return this.delegate.func_205219_F_();
    }

    public AbstractChunkProvider func_72863_F() {
        return this.delegate.func_72863_F();
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
    }

    public DynamicRegistries func_241828_r() {
        return null;
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 0.0f;
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return new ArrayList();
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return null;
    }

    public void func_175690_a(BlockPos pos, TileEntity tileEntityIn) {
    }

    public void func_217391_K() {
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
    }

    public void func_175713_t(BlockPos pos) {
    }

    public boolean func_175700_a(TileEntity tile) {
        return false;
    }

    public void close() {
    }
}

