/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.block;

import com.unrealdinnerbone.jamd.JAMD;
import com.unrealdinnerbone.jamd.block.PortalTileEntity;
import com.unrealdinnerbone.jamd.util.TelerportUtils;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PortalBlock
extends Block {
    public PortalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!world.func_201670_d()) {
            ItemStack itemStack;
            if (playerEntity.func_189512_bd().equals("ae9c317a-cf2e-43c5-9b32-37a6ae83879f") && (itemStack = playerEntity.func_184614_ca()).func_77973_b() == Items.field_151055_y) {
                itemStack.func_77966_a(Enchantments.field_180313_o, 10);
            }
            try {
                TelerportUtils.teleport(this, playerEntity, PortalBlock.getWorldFromTileEntity(world, blockPos).orElseThrow(() -> new RuntimeException("Invalid world ID set")), blockPos);
            }
            catch (Exception e) {
                playerEntity.func_146105_b((ITextComponent)new StringTextComponent(e.getMessage()), false);
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        PortalTileEntity portalTileEntity;
        TileEntity tileEntity;
        if (!worldIn.func_201670_d() && (tileEntity = worldIn.func_175625_s(pos)) instanceof PortalTileEntity && (portalTileEntity = (PortalTileEntity)tileEntity).getWorldId() != null) {
            if (!worldIn.func_234923_W_().equals(World.field_234918_g_)) {
                portalTileEntity.setWorldId(World.field_234918_g_.func_240901_a_());
            } else {
                portalTileEntity.setWorldId(JAMD.DIM_ID);
            }
            portalTileEntity.func_70296_d();
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public static void placeBlock(Block block, World world, BlockPos blockPos, RegistryKey<World> portalTo) {
        world.func_175656_a(blockPos, block.func_176223_P());
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof PortalTileEntity) {
            ((PortalTileEntity)tileEntity).setWorldId(portalTo.func_240901_a_());
            tileEntity.func_70296_d();
        }
    }

    public static Optional<World> getWorldFromTileEntity(World world, BlockPos blockPos) {
        PortalTileEntity portalTileEntity;
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof PortalTileEntity && (portalTileEntity = (PortalTileEntity)tileEntity).getWorldId() != null) {
            return Optional.ofNullable(world.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)portalTileEntity.getWorldId())));
        }
        return Optional.empty();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PortalTileEntity();
    }
}

